/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

public class PartiallyRepeatableHttpEntity
extends HttpEntityWrapper {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private int replayWriteIndex = -1;
    private int replayWriteLimit;
    private byte[] replayBuffer;
    private ReplayStream finalStream = null;
    private InputStream wrappedStream = null;

    public PartiallyRepeatableHttpEntity(HttpEntity entity, int bufferSize) throws IOException {
        super(entity);
        if (!entity.isRepeatable()) {
            this.replayBuffer = new byte[bufferSize];
            this.replayWriteLimit = bufferSize - 1;
        } else {
            this.replayBuffer = null;
        }
    }

    public PartiallyRepeatableHttpEntity(HttpEntity entity) throws IOException {
        this(entity, 4096);
    }

    public boolean isRepeatable() {
        return this.finalStream == null;
    }

    public boolean isStreaming() {
        return this.wrappedEntity.isStreaming();
    }

    public boolean isChunked() {
        return this.wrappedEntity.isChunked();
    }

    public long getContentLength() {
        return this.wrappedEntity.getContentLength();
    }

    public InputStream getContent() throws IOException {
        if (this.replayBuffer == null) {
            return this.wrappedEntity.getContent();
        }
        if (this.finalStream != null) {
            throw new IOException("Existing stream already past replay buffer capacity.");
        }
        if (this.wrappedStream == null) {
            this.wrappedStream = this.wrappedEntity.getContent();
        }
        return new ReplayStream();
    }

    public void writeTo(OutputStream stream) throws IOException {
        IOUtils.copy((InputStream)this.getContent(), (OutputStream)stream);
    }

    public void consumeContent() throws IOException {
        throw new UnsupportedOperationException();
    }

    private class ReplayStream
    extends InputStream {
        private int replayReadIndex = -1;

        private ReplayStream() {
        }

        @Override
        public int read() throws IOException {
            int b;
            if (PartiallyRepeatableHttpEntity.this.finalStream != null && PartiallyRepeatableHttpEntity.this.finalStream != this) {
                throw new IOException("Replay stream taken over by another consumer.");
            }
            if (this.replayReadIndex < PartiallyRepeatableHttpEntity.this.replayWriteIndex) {
                b = PartiallyRepeatableHttpEntity.this.replayBuffer[++this.replayReadIndex];
            } else {
                b = PartiallyRepeatableHttpEntity.this.wrappedStream.read();
                if (b > -1) {
                    if (PartiallyRepeatableHttpEntity.this.replayWriteIndex < PartiallyRepeatableHttpEntity.this.replayWriteLimit) {
                        ((PartiallyRepeatableHttpEntity)PartiallyRepeatableHttpEntity.this).replayBuffer[++((PartiallyRepeatableHttpEntity)PartiallyRepeatableHttpEntity.this).replayWriteIndex] = (byte)b;
                        ++this.replayReadIndex;
                    } else {
                        PartiallyRepeatableHttpEntity.this.finalStream = this;
                    }
                }
            }
            return b;
        }

        @Override
        public int read(byte[] buffer, int offset, int limit) throws IOException {
            int count;
            if (PartiallyRepeatableHttpEntity.this.finalStream != null && PartiallyRepeatableHttpEntity.this.finalStream != this) {
                throw new IOException("Replay stream taken over by another consumer.");
            }
            if (this.replayReadIndex < PartiallyRepeatableHttpEntity.this.replayWriteIndex) {
                count = PartiallyRepeatableHttpEntity.this.replayWriteIndex - this.replayReadIndex;
                count = Math.min(limit, count);
                System.arraycopy(PartiallyRepeatableHttpEntity.this.replayBuffer, this.replayReadIndex + 1, buffer, offset, count);
                this.replayReadIndex += count;
            } else {
                count = PartiallyRepeatableHttpEntity.this.wrappedStream.read(buffer, offset, limit);
                if (count > -1) {
                    if (PartiallyRepeatableHttpEntity.this.replayWriteIndex + count < PartiallyRepeatableHttpEntity.this.replayWriteLimit) {
                        System.arraycopy(buffer, offset, PartiallyRepeatableHttpEntity.this.replayBuffer, PartiallyRepeatableHttpEntity.this.replayWriteIndex + 1, count);
                        this.replayReadIndex += count;
                        PartiallyRepeatableHttpEntity.this.replayWriteIndex += count;
                    } else {
                        PartiallyRepeatableHttpEntity.this.finalStream = this;
                    }
                }
            }
            return count;
        }
    }
}

