/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.transaction_impl;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.transaction.TransactionSpecification;
import org.apache.directory.api.ldap.model.message.Control;

public class TransactionSpecificationDecorator
extends ControlDecorator<TransactionSpecification>
implements TransactionSpecification {
    public TransactionSpecificationDecorator(LdapApiService codec, TransactionSpecification decoratedControl) {
        super(codec, (Control)decoratedControl);
    }

    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        this.setIdentifier(controlBytes);
        return this;
    }

    public int computeLength() {
        byte[] identifier = ((TransactionSpecification)this.getDecorated()).getIdentifier();
        if (identifier != null) {
            return identifier.length;
        }
        return -1;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        byte[] identifier = ((TransactionSpecification)this.getDecorated()).getIdentifier();
        if (identifier != null) {
            ByteBuffer encoded = ByteBuffer.allocate(identifier.length);
            encoded.put(identifier);
            return encoded;
        }
        return ByteBuffer.allocate(0);
    }

    public byte[] getIdentifier() {
        return ((TransactionSpecification)this.getDecorated()).getIdentifier();
    }

    public void setIdentifier(byte[] identifier) {
        ((TransactionSpecification)this.getDecorated()).setIdentifier(identifier);
    }
}

