/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.knox.gateway.topology.discovery.ServiceDiscovery;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;

public class ClouderaManagerCluster
implements ServiceDiscovery.Cluster {
    private String name;
    private Set<ServiceModel> serviceModels = new HashSet<ServiceModel>();

    ClouderaManagerCluster(String clusterName) {
        this.name = clusterName;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getServiceURLs(String serviceName) {
        ArrayList<String> urls = new ArrayList<String>();
        for (ServiceModel sm : this.serviceModels) {
            if (!sm.getService().equals(serviceName)) continue;
            urls.add(sm.getServiceUrl());
        }
        return urls;
    }

    public List<String> getServiceURLs(String serviceName, Map<String, String> serviceParams) {
        return this.getServiceURLs(serviceName);
    }

    public ServiceDiscovery.Cluster.ZooKeeperConfig getZooKeeperConfiguration(String serviceName) {
        return null;
    }

    void addServiceModels(Set<ServiceModel> serviceModels) {
        this.serviceModels.addAll(serviceModels);
    }

    static class ServiceConfiguration {
        private String type;
        private String version;
        private Map<String, String> props;

        ServiceConfiguration(String type, String version, Map<String, String> properties) {
            this.type = type;
            this.version = version;
            this.props = properties;
        }

        public String getVersion() {
            return this.version;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, String> getProperties() {
            return this.props;
        }
    }
}

