/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.atlas;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class AtlasServiceModelGenerator
extends AbstractServiceModelGenerator {
    private static final String SERVICE = "ATLAS";
    private static final String SERVICE_TYPE = "ATLAS";
    private static final String ROLE_TYPE = "ATLAS_SERVER";

    @Override
    public boolean handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        return "ATLAS".equals(service.getType()) && ROLE_TYPE.equals(role.getType());
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) throws ApiException {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        boolean sslEnabled = Boolean.parseBoolean(this.getRoleConfigValue(roleConfig, "ssl_enabled"));
        if (sslEnabled) {
            scheme = "https";
            port = this.getRoleConfigValue(roleConfig, "atlas_server_https_port");
        } else {
            scheme = "http";
            port = this.getRoleConfigValue(roleConfig, "atlas_server_http_port");
        }
        return new ServiceModel(ServiceModel.Type.UI, "ATLAS", String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
    }
}

