/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.codec.search.SubstringFilter;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreInitial
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreInitial.class);

    public StoreInitial() {
        super("Store an initial value");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        SubstringFilter substringFilter = (SubstringFilter)searchRequestDecorator.getTerminalFilter();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_05154_EMPTY_SUBSTRING_INITIAL_FILTER_PDU, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        substringFilter.setInitialSubstrings(Strings.utf8ToString((byte[])tlv.getValue().getData()));
        searchRequestDecorator.unstackFilters((Asn1Container)container);
    }
}

