/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import org.apache.directory.api.ldap.codec.api.BinaryAttributeDetector;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.SchemaBinaryAttributeDetector;
import org.apache.directory.api.ldap.model.exception.ResponseCarryingMessageException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Request;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.message.ResultResponseRequest;
import org.apache.directory.api.ldap.model.message.extended.NoticeOfDisconnect;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.FilterEvent;
import org.apache.mina.filter.ssl.SslEvent;
import org.apache.mina.handler.demux.DemuxingIoHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LdapProtocolHandler
extends DemuxingIoHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LdapProtocolHandler.class);
    private final LdapServer ldapServer;

    LdapProtocolHandler(LdapServer ldapServer) {
        this.ldapServer = ldapServer;
    }

    public void sessionCreated(IoSession session) throws Exception {
        LdapSession ldapSession = new LdapSession(session);
        this.ldapServer.getLdapSessionManager().addLdapSession(ldapSession);
        session.setAttribute((Object)"LDAP-maxPduSize", (Object)this.ldapServer.getDirectoryService().getMaxPDUSize());
        LdapMessageContainer ldapMessageContainer = new LdapMessageContainer(this.ldapServer.getDirectoryService().getLdapCodecService(), (BinaryAttributeDetector)new SchemaBinaryAttributeDetector(this.ldapServer.getDirectoryService().getSchemaManager()));
        session.setAttribute((Object)"LDAP-container", (Object)ldapMessageContainer);
    }

    public void sessionClosed(IoSession session) {
        LdapSession ldapSession = this.ldapServer.getLdapSessionManager().removeLdapSession(session);
        this.cleanUpSession(ldapSession);
    }

    private void cleanUpSession(LdapSession ldapSession) {
        if (ldapSession == null) {
            LOG.debug("Null LdapSession given to cleanUpSession.");
            return;
        }
        LOG.debug("Cleaning the {} session", (Object)ldapSession);
        ldapSession.abandonAllOutstandingRequests();
        if (!ldapSession.getIoSession().isClosing() || ldapSession.getIoSession().isConnected()) {
            try {
                ldapSession.getIoSession().closeNow();
            }
            catch (Throwable t) {
                LOG.warn("Failed to close IoSession for LdapSession.");
            }
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        if (message instanceof IoBuffer) {
            return;
        }
        super.messageSent(session, message);
    }

    public void event(IoSession session, FilterEvent event) throws Exception {
        if (event instanceof SslEvent) {
            if ((SslEvent)event == SslEvent.SECURED) {
                LdapSession ldapSession = this.ldapServer.getLdapSessionManager().getLdapSession(session);
                LOG.debug("Session {} secured", (Object)ldapSession);
            } else {
                LdapSession ldapSession = this.ldapServer.getLdapSessionManager().getLdapSession(session);
                LOG.debug("Session {} not secured", (Object)ldapSession);
            }
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (((Request)message).getControls().size() > 0 && message instanceof ResultResponseRequest) {
            ResultResponseRequest req = (ResultResponseRequest)message;
            for (Control control : req.getControls().values()) {
                if (!control.isCritical() || this.ldapServer.getSupportedControls().contains(control.getOid())) continue;
                ResultResponse resp = req.getResultResponse();
                resp.getLdapResult().setDiagnosticMessage("Unsupport critical control: " + control.getOid());
                resp.getLdapResult().setResultCode(ResultCodeEnum.UNAVAILABLE_CRITICAL_EXTENSION);
                session.write((Object)resp);
                return;
            }
        }
        super.messageReceived(session, message);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        ResponseCarryingMessageException rcme;
        if (cause.getCause() instanceof ResponseCarryingMessageException && (rcme = (ResponseCarryingMessageException)cause.getCause()).getResponse() != null) {
            session.write((Object)rcme.getResponse());
            return;
        }
        LOG.warn("Unexpected exception forcing session to close: sending disconnect notice to client.", cause);
        session.write((Object)NoticeOfDisconnect.PROTOCOLERROR);
        LdapSession ldapSession = this.ldapServer.getLdapSessionManager().removeLdapSession(session);
        this.cleanUpSession(ldapSession);
        session.closeNow();
    }
}

