/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.jaas;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jasig.cas.client.authentication.SimpleGroup;
import org.jasig.cas.client.authentication.SimplePrincipal;
import org.jasig.cas.client.jaas.AssertionPrincipal;
import org.jasig.cas.client.jaas.TicketCredential;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.ReflectUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasLoginModule
implements LoginModule {
    public static final String LOGIN_NAME = "javax.security.auth.login.name";
    public static final String DEFAULT_PRINCIPAL_GROUP_NAME = "CallerPrincipal";
    public static final String DEFAULT_ROLE_GROUP_NAME = "Roles";
    public static final int DEFAULT_CACHE_TIMEOUT = 480;
    public static final TimeUnit DEFAULT_CACHE_TIMEOUT_UNIT = TimeUnit.MINUTES;
    protected static final Map<TicketCredential, Assertion> ASSERTION_CACHE = new HashMap<TicketCredential, Assertion>();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected TicketValidator ticketValidator;
    protected String service;
    protected Assertion assertion;
    protected TicketCredential ticket;
    protected Map<String, Object> sharedState;
    protected String[] defaultRoles;
    protected Set<String> roleAttributeNames = new HashSet<String>();
    protected String principalGroupName = "CallerPrincipal";
    protected String roleGroupName = "Roles";
    protected boolean cacheAssertions;
    protected int cacheTimeout = 480;
    protected TimeUnit cacheTimeoutUnit = DEFAULT_CACHE_TIMEOUT_UNIT;

    @Override
    public final void initialize(Subject subject, CallbackHandler handler, Map<String, ?> state, Map<String, ?> options) {
        this.assertion = null;
        this.callbackHandler = handler;
        this.subject = subject;
        this.sharedState = state;
        this.sharedState = new HashMap(state);
        String ticketValidatorClass = null;
        for (String key : options.keySet()) {
            this.logger.trace("Processing option {}", (Object)key);
            if ("service".equals(key)) {
                this.service = (String)options.get(key);
                this.logger.debug("Set service={}", (Object)this.service);
                continue;
            }
            if ("ticketValidatorClass".equals(key)) {
                ticketValidatorClass = (String)options.get(key);
                this.logger.debug("Set ticketValidatorClass={}", (Object)ticketValidatorClass);
                continue;
            }
            if ("defaultRoles".equals(key)) {
                String roles = (String)options.get(key);
                this.logger.trace("Got defaultRoles value {}", (Object)roles);
                this.defaultRoles = roles.split(",\\s*");
                this.logger.debug("Set defaultRoles={}", Arrays.asList(this.defaultRoles));
                continue;
            }
            if ("roleAttributeNames".equals(key)) {
                String attrNames = (String)options.get(key);
                this.logger.trace("Got roleAttributeNames value {}", (Object)attrNames);
                String[] attributes = attrNames.split(",\\s*");
                this.roleAttributeNames.addAll(Arrays.asList(attributes));
                this.logger.debug("Set roleAttributeNames={}", this.roleAttributeNames);
                continue;
            }
            if ("principalGroupName".equals(key)) {
                this.principalGroupName = (String)options.get(key);
                this.logger.debug("Set principalGroupName={}", (Object)this.principalGroupName);
                continue;
            }
            if ("roleGroupName".equals(key)) {
                this.roleGroupName = (String)options.get(key);
                this.logger.debug("Set roleGroupName={}", (Object)this.roleGroupName);
                continue;
            }
            if ("cacheAssertions".equals(key)) {
                this.cacheAssertions = Boolean.parseBoolean((String)options.get(key));
                this.logger.debug("Set cacheAssertions={}", (Object)this.cacheAssertions);
                continue;
            }
            if ("cacheTimeout".equals(key)) {
                this.cacheTimeout = Integer.parseInt((String)options.get(key));
                this.logger.debug("Set cacheTimeout={}", (Object)this.cacheTimeout);
                continue;
            }
            if (!"cacheTimeoutUnit".equals(key)) continue;
            this.cacheTimeoutUnit = Enum.valueOf(TimeUnit.class, (String)options.get(key));
            this.logger.debug("Set cacheTimeoutUnit={}", (Object)this.cacheTimeoutUnit);
        }
        if (this.cacheAssertions) {
            this.cleanCache();
        }
        CommonUtils.assertNotNull(ticketValidatorClass, "ticketValidatorClass is required.");
        this.ticketValidator = this.createTicketValidator(ticketValidatorClass, options);
    }

    protected boolean preLogin() {
        return true;
    }

    protected void postLogin(boolean result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean login() throws LoginException {
        this.logger.debug("Performing login.");
        if (!this.preLogin()) {
            this.logger.debug("preLogin failed.");
            return false;
        }
        NameCallback serviceCallback = new NameCallback("service");
        PasswordCallback ticketCallback = new PasswordCallback("ticket", false);
        boolean result = false;
        try {
            try {
                this.callbackHandler.handle(new Callback[]{ticketCallback, serviceCallback});
            }
            catch (IOException e) {
                this.logger.info("Login failed due to IO exception in callback handler: {}", (Throwable)e);
                throw (LoginException)new LoginException("IO exception in callback handler: " + e).initCause(e);
            }
            catch (UnsupportedCallbackException e) {
                this.logger.info("Login failed due to unsupported callback: {}", (Throwable)e);
                throw (LoginException)new LoginException("Callback handler does not support PasswordCallback and TextInputCallback.").initCause(e);
            }
            if (ticketCallback.getPassword() != null) {
                String service;
                this.ticket = new TicketCredential(new String(ticketCallback.getPassword()));
                String string = service = CommonUtils.isNotBlank(serviceCallback.getName()) ? serviceCallback.getName() : this.service;
                if (this.cacheAssertions) {
                    this.assertion = ASSERTION_CACHE.get(this.ticket);
                    if (this.assertion != null) {
                        this.logger.debug("Assertion found in cache.");
                    }
                }
                if (this.assertion == null) {
                    this.logger.debug("CAS assertion is null; ticket validation required.");
                    if (CommonUtils.isBlank(service)) {
                        this.logger.info("Login failed because required CAS service parameter not provided.");
                        throw new LoginException("Neither login module nor callback handler provided required service parameter.");
                    }
                    try {
                        this.logger.debug("Attempting ticket validation with service={}  and ticket={}", (Object)service, (Object)this.ticket);
                        this.assertion = this.ticketValidator.validate(this.ticket.getName(), service);
                    }
                    catch (Exception e) {
                        this.logger.info("Login failed due to CAS ticket validation failure: {}", (Throwable)e);
                        throw (LoginException)new LoginException("CAS ticket validation failed: " + e).initCause(e);
                    }
                }
            } else {
                this.logger.info("Login failed because callback handler did not provide CAS ticket.");
                throw new LoginException("Callback handler did not provide CAS ticket.");
            }
            this.logger.info("Login succeeded.");
            result = true;
        }
        finally {
            this.postLogin(result);
        }
        return result;
    }

    @Override
    public final boolean abort() throws LoginException {
        if (this.ticket != null) {
            this.ticket = null;
        }
        if (this.assertion != null) {
            this.assertion = null;
        }
        return true;
    }

    protected boolean preCommit() {
        return true;
    }

    protected void postCommit(boolean result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean commit() throws LoginException {
        if (!this.preCommit()) {
            return false;
        }
        boolean result = false;
        try {
            if (this.assertion != null) {
                if (this.ticket == null) {
                    throw new LoginException("Ticket credential not found.");
                }
                this.subject.getPrivateCredentials().add(this.ticket);
                AssertionPrincipal casPrincipal = new AssertionPrincipal(this.assertion.getPrincipal().getName(), this.assertion);
                this.subject.getPrincipals().add(casPrincipal);
                SimpleGroup principalGroup = new SimpleGroup(this.principalGroupName);
                principalGroup.addMember(casPrincipal);
                this.subject.getPrincipals().add(principalGroup);
                SimpleGroup roleGroup = new SimpleGroup(this.roleGroupName);
                for (String defaultRole : this.defaultRoles) {
                    roleGroup.addMember(new SimplePrincipal(defaultRole));
                }
                Map<String, Object> attributes = this.assertion.getPrincipal().getAttributes();
                for (String key : attributes.keySet()) {
                    if (!this.roleAttributeNames.contains(key)) continue;
                    Object value = attributes.get(key);
                    if (value instanceof Collection) {
                        for (Object o : (Collection)value) {
                            roleGroup.addMember(new SimplePrincipal(o.toString()));
                        }
                        continue;
                    }
                    roleGroup.addMember(new SimplePrincipal(value.toString()));
                }
                this.subject.getPrincipals().add(roleGroup);
                this.sharedState.put(LOGIN_NAME, this.assertion.getPrincipal().getName());
                this.logger.debug("Created JAAS subject with principals: {}", this.subject.getPrincipals());
                if (this.cacheAssertions) {
                    this.logger.debug("Caching assertion for principal {}", (Object)this.assertion.getPrincipal());
                    ASSERTION_CACHE.put(this.ticket, this.assertion);
                }
            } else if (this.ticket != null) {
                this.ticket = null;
            }
            result = true;
        }
        finally {
            this.postCommit(result);
        }
        return result;
    }

    @Override
    public final boolean logout() throws LoginException {
        this.logger.debug("Performing logout.");
        if (!this.preLogout()) {
            return false;
        }
        if (this.cacheAssertions) {
            for (TicketCredential ticket : this.subject.getPrivateCredentials(TicketCredential.class)) {
                this.logger.debug("Removing cached assertion for {}", (Object)ticket);
                ASSERTION_CACHE.remove(ticket);
            }
        }
        this.removePrincipalsOfType(AssertionPrincipal.class);
        this.removePrincipalsOfType(SimplePrincipal.class);
        this.removePrincipalsOfType(SimpleGroup.class);
        this.removeCredentialsOfType(TicketCredential.class);
        this.logger.info("Logout succeeded.");
        this.postLogout();
        return true;
    }

    protected boolean preLogout() {
        return true;
    }

    protected void postLogout() {
    }

    private TicketValidator createTicketValidator(String className, Map<String, ?> propertyMap) {
        CommonUtils.assertTrue(propertyMap.containsKey("casServerUrlPrefix"), "Required property casServerUrlPrefix not found.");
        Class validatorClass = ReflectUtils.loadClass(className);
        TicketValidator validator = (TicketValidator)ReflectUtils.newInstance(validatorClass, propertyMap.get("casServerUrlPrefix"));
        try {
            BeanInfo info = Introspector.getBeanInfo(validatorClass);
            for (String property : propertyMap.keySet()) {
                if ("casServerUrlPrefix".equals(property)) continue;
                this.logger.debug("Attempting to set TicketValidator property {}", (Object)property);
                String value = (String)propertyMap.get(property);
                PropertyDescriptor pd = ReflectUtils.getPropertyDescriptor(info, property);
                if (pd != null) {
                    ReflectUtils.setProperty(property, CasLoginModule.convertIfNecessary(pd, value), validator, info);
                    this.logger.debug("Set {} = {}", (Object)property, (Object)value);
                    continue;
                }
                this.logger.warn("Cannot find property {} on {}", (Object)property, (Object)className);
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Error getting bean info for " + validatorClass, e);
        }
        return validator;
    }

    private static Object convertIfNecessary(PropertyDescriptor pd, String value) {
        if (String.class.equals(pd.getPropertyType())) {
            return value;
        }
        if (Boolean.TYPE.equals(pd.getPropertyType())) {
            return Boolean.valueOf(value);
        }
        if (Integer.TYPE.equals(pd.getPropertyType())) {
            return new Integer(value);
        }
        if (Long.TYPE.equals(pd.getPropertyType())) {
            return new Long(value);
        }
        throw new IllegalArgumentException("No conversion strategy exists for property " + pd.getName() + " of type " + pd.getPropertyType());
    }

    private void removePrincipalsOfType(Class<? extends Principal> clazz) {
        this.subject.getPrincipals().removeAll(this.subject.getPrincipals(clazz));
    }

    private void removeCredentialsOfType(Class<? extends Principal> clazz) {
        this.subject.getPrivateCredentials().removeAll(this.subject.getPrivateCredentials(clazz));
    }

    private void cleanCache() {
        this.logger.debug("Cleaning assertion cache of size {}", (Object)ASSERTION_CACHE.size());
        Iterator<Map.Entry<TicketCredential, Assertion>> iter = ASSERTION_CACHE.entrySet().iterator();
        Calendar cutoff = Calendar.getInstance();
        cutoff.setTimeInMillis(System.currentTimeMillis() - this.cacheTimeoutUnit.toMillis(this.cacheTimeout));
        while (iter.hasNext()) {
            Assertion assertion = iter.next().getValue();
            Calendar created = Calendar.getInstance();
            created.setTime(assertion.getValidFromDate());
            if (!created.before(cutoff)) continue;
            this.logger.debug("Removing expired assertion for principal {}", (Object)assertion.getPrincipal());
            iter.remove();
        }
    }
}

