/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.encrypturi.impl;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.commons.codec.binary.Base64;
import org.apache.knox.gateway.encrypturi.EncryptStepContextParams;
import org.apache.knox.gateway.encrypturi.api.DecryptUriDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteStepProcessor;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteStepStatus;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.CryptoService;
import org.apache.knox.gateway.services.security.EncryptionResult;
import org.apache.knox.gateway.util.urltemplate.Evaluator;
import org.apache.knox.gateway.util.urltemplate.Expander;
import org.apache.knox.gateway.util.urltemplate.Params;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Template;

public class DecryptUriProcessor
implements UrlRewriteStepProcessor<DecryptUriDescriptor> {
    private String clusterName;
    private CryptoService cryptoService;
    private String param;

    public String getType() {
        return "decrypt";
    }

    public void initialize(UrlRewriteEnvironment environment, DecryptUriDescriptor descriptor) throws Exception {
        this.clusterName = (String)environment.getAttribute("org.apache.knox.gateway.gateway.cluster");
        GatewayServices services = (GatewayServices)environment.getAttribute("org.apache.knox.gateway.gateway.services");
        this.cryptoService = (CryptoService)services.getService(ServiceType.CRYPTO_SERVICE);
        this.param = descriptor.getParam();
    }

    public UrlRewriteStepStatus process(UrlRewriteContext context) throws Exception {
        if (this.param != null && !this.param.isEmpty()) {
            Template template = Parser.parseTemplate((String)("{" + this.param + "}"));
            String resolvedTemplate = Expander.expandToString((Template)template, (Params)context.getParameters(), (Evaluator)context.getEvaluator());
            String url = this.decode(resolvedTemplate);
            EncryptStepContextParams params = new EncryptStepContextParams();
            params.addParam(this.param, Collections.singletonList(url));
            context.addParameters((Params)params);
            return UrlRewriteStepStatus.SUCCESS;
        }
        return UrlRewriteStepStatus.FAILURE;
    }

    public void destroy() {
    }

    private String decode(String string) throws UnsupportedEncodingException {
        byte[] bytes = Base64.decodeBase64((String)string);
        EncryptionResult result = EncryptionResult.fromByteArray((byte[])bytes);
        byte[] clear = this.cryptoService.decryptForCluster(this.clusterName, "encryptQueryString", result.cipher, result.iv, result.salt);
        if (clear != null) {
            return new String(clear, StandardCharsets.UTF_8);
        }
        return null;
    }
}

