/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.Arrays;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapUtils;
import org.ldaptive.ResponseMessage;
import org.ldaptive.SortBehavior;
import org.ldaptive.control.ResponseControl;

public class SearchEntry
extends LdapEntry
implements ResponseMessage {
    private static final int HASH_CODE_SEED = 347;
    private static final long serialVersionUID = 3016288847468612093L;
    private final ResponseControl[] responseControls;
    private final int messageId;

    public SearchEntry(int id, ResponseControl[] c) {
        this.messageId = id;
        this.responseControls = c;
    }

    public SearchEntry(int id, ResponseControl[] c, SortBehavior sb) {
        super(sb);
        this.messageId = id;
        this.responseControls = c;
    }

    public ResponseControl[] getControls() {
        return this.responseControls;
    }

    @Override
    public ResponseControl getControl(String oid) {
        if (this.getControls() != null) {
            for (ResponseControl c : this.getControls()) {
                if (!c.getOID().equals(oid)) continue;
                return c;
            }
        }
        return null;
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (super.equals(o)) {
            SearchEntry v = (SearchEntry)o;
            return LdapUtils.areEqual(this.messageId, v.messageId) && LdapUtils.areEqual(this.responseControls, v.responseControls);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(347, this.getDn() != null ? this.getDn().toLowerCase() : null, this.getAttributes(), this.messageId, this.responseControls);
    }

    @Override
    public String toString() {
        return String.format("[dn=%s%s, responseControls=%s, messageId=%s]", this.getDn(), this.getAttributes(), Arrays.toString(this.responseControls), this.messageId);
    }
}

