/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth.ext;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapUtils;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.ext.EDirectoryAccountState;
import org.ldaptive.io.GeneralizedTimeValueTranscoder;

public class EDirectoryAuthenticationResponseHandler
implements AuthenticationResponseHandler {
    private static final int HASH_CODE_SEED = 1213;
    private int warningHours;

    public EDirectoryAuthenticationResponseHandler() {
    }

    public EDirectoryAuthenticationResponseHandler(int hours) {
        if (hours < 0) {
            throw new IllegalArgumentException("Hours must be >= 0");
        }
        this.warningHours = hours;
    }

    public EDirectoryAuthenticationResponseHandler(String hours) {
        this((int)LdapUtils.durationDecode(hours, TimeUnit.HOURS));
    }

    @Override
    public void handle(AuthenticationResponse response) {
        if (response.getMessage() != null) {
            EDirectoryAccountState.Error edError = EDirectoryAccountState.Error.parse(response.getMessage());
            if (edError != null) {
                response.setAccountState(new EDirectoryAccountState(edError));
            }
        } else if (((Boolean)response.getResult()).booleanValue()) {
            int loginRemainingValue;
            LdapEntry entry = response.getLdapEntry();
            LdapAttribute expTime = entry.getAttribute("passwordExpirationTime");
            LdapAttribute loginRemaining = entry.getAttribute("loginGraceRemaining");
            int n = loginRemainingValue = loginRemaining != null ? Integer.parseInt(loginRemaining.getStringValue()) : 0;
            if (expTime != null) {
                Calendar exp = expTime.getValue(new GeneralizedTimeValueTranscoder());
                if (this.warningHours > 0) {
                    Calendar now = Calendar.getInstance();
                    Calendar warn = (Calendar)exp.clone();
                    warn.add(11, -this.warningHours);
                    if (now.after(warn)) {
                        response.setAccountState(new EDirectoryAccountState(exp, loginRemainingValue));
                    }
                } else {
                    response.setAccountState(new EDirectoryAccountState(exp, loginRemainingValue));
                }
            } else if (loginRemaining != null) {
                response.setAccountState(new EDirectoryAccountState(null, loginRemainingValue));
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EDirectoryAuthenticationResponseHandler) {
            EDirectoryAuthenticationResponseHandler v = (EDirectoryAuthenticationResponseHandler)o;
            return LdapUtils.areEqual(this.warningHours, v.warningHours);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(1213, this.warningHours);
    }

    public String toString() {
        return String.format("[%s@%d::warningHours=%s]", this.getClass().getName(), this.hashCode(), this.warningHours);
    }
}

