/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.identityasserter.common.filter;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.knox.gateway.IdentityAsserterMessages;
import org.apache.knox.gateway.audit.api.AuditContext;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.filter.security.AbstractIdentityAssertionBase;
import org.apache.knox.gateway.i18n.GatewaySpiResources;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.security.GroupPrincipal;
import org.apache.knox.gateway.security.ImpersonatedPrincipal;
import org.apache.knox.gateway.security.PrimaryPrincipal;
import org.apache.knox.gateway.security.SubjectUtils;

public abstract class AbstractIdentityAssertionFilter
extends AbstractIdentityAssertionBase
implements Filter {
    private IdentityAsserterMessages LOG = (IdentityAsserterMessages)MessagesFactory.get(IdentityAsserterMessages.class);
    private static final GatewaySpiResources RES = (GatewaySpiResources)ResourcesFactory.get(GatewaySpiResources.class);
    private static AuditService auditService = AuditServiceFactory.getAuditService();
    private static Auditor auditor = auditService.getAuditor("audit", "knox", "knox");

    public abstract String[] mapGroupPrincipals(String var1, Subject var2);

    public abstract String mapUserPrincipal(String var1);

    protected void continueChainAsPrincipal(HttpServletRequestWrapper request, ServletResponse response, FilterChain chain, String mappedPrincipalName, String[] groups) throws IOException, ServletException {
        boolean groupsMapped;
        boolean impersonationNeeded = false;
        Subject currentSubject = Subject.getSubject(AccessController.getContext());
        if (currentSubject == null) {
            this.LOG.subjectNotAvailable();
            throw new IllegalStateException("Required Subject Missing");
        }
        String primaryPrincipalName = SubjectUtils.getPrimaryPrincipalName((Subject)currentSubject);
        if (primaryPrincipalName != null) {
            if (!primaryPrincipalName.equals(mappedPrincipalName)) {
                impersonationNeeded = true;
                AuditContext context = auditService.getContext();
                context.setProxyUsername(mappedPrincipalName);
                auditService.attachContext(context);
                auditor.audit("identity-mapping", primaryPrincipalName, "principal", "success", RES.effectiveUser(mappedPrincipalName));
            }
        } else {
            primaryPrincipalName = request.getUserPrincipal().getName();
        }
        Set currentGroups = SubjectUtils.getGroupPrincipals((Subject)currentSubject);
        boolean bl = groupsMapped = groups != null || !currentGroups.isEmpty();
        if (impersonationNeeded || groupsMapped) {
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)new PrimaryPrincipal(primaryPrincipalName));
            for (Object obj : currentGroups) {
                subject.getPrincipals().add((Principal)obj);
            }
            if (impersonationNeeded) {
                ImpersonatedPrincipal impersonationPrincipal = new ImpersonatedPrincipal(mappedPrincipalName);
                subject.getPrincipals().add((Principal)impersonationPrincipal);
            }
            if (groupsMapped) {
                this.addMappedGroupsToSubject(mappedPrincipalName, groups, subject);
            }
            this.doAs((ServletRequest)request, response, chain, subject);
        } else {
            this.doFilterInternal((ServletRequest)request, response, chain);
        }
    }

    private void doAs(final ServletRequest request, final ServletResponse response, final FilterChain chain, Subject subject) throws IOException, ServletException {
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    AbstractIdentityAssertionFilter.this.doFilterInternal(request, response, chain);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
    }

    private void addMappedGroupsToSubject(String mappedPrincipalName, String[] groups, Subject subject) {
        if (groups != null) {
            auditor.audit("identity-mapping", mappedPrincipalName, "principal", "success", RES.groupsList(Arrays.toString(groups)));
            for (String group : groups) {
                subject.getPrincipals().add((Principal)new GroupPrincipal(group));
            }
        }
    }

    private void doFilterInternal(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
    }
}

