/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.webappsec.deploy;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;

public class WebAppSecContributor
extends ProviderDeploymentContributorBase {
    private static final String ROLE = "webappsec";
    private static final String NAME = "WebAppSec";
    private static final String CSRF_SUFFIX = "_CSRF";
    private static final String CSRF_FILTER_CLASSNAME = "org.apache.knox.gateway.webappsec.filter.CSRFPreventionFilter";
    private static final String CSRF_ENABLED = "csrf.enabled";
    private static final String CORS_SUFFIX = "_CORS";
    private static final String CORS_FILTER_CLASSNAME = "com.thetransactioncompany.cors.CORSFilter";
    private static final String CORS_ENABLED = "cors.enabled";
    private static final String XFRAME_OPTIONS_SUFFIX = "_XFRAMEOPTIONS";
    private static final String XFRAME_OPTIONS_FILTER_CLASSNAME = "org.apache.knox.gateway.webappsec.filter.XFrameOptionsFilter";
    private static final String XFRAME_OPTIONS_ENABLED = "xframe.options.enabled";
    private static final String XCONTENT_TYPE_OPTIONS_SUFFIX = "_XCONTENTTYPEOPTIONS";
    private static final String XCONTENT_TYPE_OPTIONS_FILTER_CLASSNAME = "org.apache.knox.gateway.webappsec.filter.XContentTypeOptionsFilter";
    private static final String XCONTENT_TYPE_OPTIONS_ENABLED = "xcontent-type.options.enabled";
    private static final String XSS_PROTECTION_SUFFIX = "_XSSPROTECTION";
    private static final String XSS_PROTECTION_FILTER_CLASSNAME = "org.apache.knox.gateway.webappsec.filter.XSSProtectionFilter";
    private static final String XSS_PROTECTION_ENABLED = "xss.protection.enabled";
    private static final String STRICT_TRANSPORT_SUFFIX = "_STRICTTRANSPORT";
    private static final String STRICT_TRANSPORT_FILTER_CLASSNAME = "org.apache.knox.gateway.webappsec.filter.StrictTransportFilter";
    private static final String STRICT_TRANSPORT_ENABLED = "strict.transport.enabled";
    private static final String RATE_LIMITING_FILTER_CLASSNAME = "org.eclipse.jetty.servlets.DoSFilter";
    private static final String RATE_LIMITING_PREFIX = "rate.limiting";
    private static final String RATE_LIMITING_SUFFIX = "_RATE.LIMITING";
    private static final String RATE_LIMITING_ENABLED = "rate.limiting.enabled";

    public String getRole() {
        return ROLE;
    }

    public String getName() {
        return NAME;
    }

    public void initializeContribution(DeploymentContext context) {
        super.initializeContribution(context);
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        Provider webappsec = context.getTopology().getProvider(ROLE, NAME);
        if (webappsec != null && webappsec.isEnabled()) {
            Map map = provider.getParams();
            if (params == null) {
                params = new ArrayList<FilterParamDescriptor>();
            }
            Map providerParams = provider.getParams();
            String rateLimitingEnabled = (String)map.get(RATE_LIMITING_ENABLED);
            if (Boolean.parseBoolean(rateLimitingEnabled)) {
                this.provisionConfig(resource, providerParams, params, "rate.limiting.", true, false);
                resource.addFilter().name(this.getName() + RATE_LIMITING_SUFFIX).role(this.getRole()).impl(RATE_LIMITING_FILTER_CLASSNAME).params(params);
            }
            params = new ArrayList<FilterParamDescriptor>();
            String corsEnabled = (String)map.get(CORS_ENABLED);
            if (Boolean.parseBoolean(corsEnabled)) {
                this.provisionConfig(resource, providerParams, params, "cors.");
                resource.addFilter().name(this.getName() + CORS_SUFFIX).role(this.getRole()).impl(CORS_FILTER_CLASSNAME).params(params);
            }
            params = new ArrayList<FilterParamDescriptor>();
            String csrfEnabled = (String)map.get(CSRF_ENABLED);
            if (Boolean.parseBoolean(csrfEnabled)) {
                this.provisionConfig(resource, providerParams, params, "csrf.");
                resource.addFilter().name(this.getName() + CSRF_SUFFIX).role(this.getRole()).impl(CSRF_FILTER_CLASSNAME).params(params);
            }
            params = new ArrayList<FilterParamDescriptor>();
            String xframeOptionsEnabled = (String)map.get(XFRAME_OPTIONS_ENABLED);
            if (Boolean.parseBoolean(xframeOptionsEnabled)) {
                this.provisionConfig(resource, providerParams, params, "xframe.");
                resource.addFilter().name(this.getName() + XFRAME_OPTIONS_SUFFIX).role(this.getRole()).impl(XFRAME_OPTIONS_FILTER_CLASSNAME).params(params);
            }
            params = new ArrayList<FilterParamDescriptor>();
            String xContentTypeOptionsEnabled = (String)map.get(XCONTENT_TYPE_OPTIONS_ENABLED);
            if (Boolean.parseBoolean(xContentTypeOptionsEnabled)) {
                this.provisionConfig(resource, providerParams, params, "xcontent-type.");
                resource.addFilter().name(this.getName() + XCONTENT_TYPE_OPTIONS_SUFFIX).role(this.getRole()).impl(XCONTENT_TYPE_OPTIONS_FILTER_CLASSNAME).params(params);
            }
            params = new ArrayList<FilterParamDescriptor>();
            String xssProtectionEnabled = (String)map.get(XSS_PROTECTION_ENABLED);
            if (Boolean.parseBoolean(xssProtectionEnabled)) {
                this.provisionConfig(resource, providerParams, params, "xss.");
                resource.addFilter().name(this.getName() + XSS_PROTECTION_SUFFIX).role(this.getRole()).impl(XSS_PROTECTION_FILTER_CLASSNAME).params(params);
            }
            params = new ArrayList<FilterParamDescriptor>();
            String strictTranportEnabled = (String)map.get(STRICT_TRANSPORT_ENABLED);
            if (Boolean.parseBoolean(strictTranportEnabled)) {
                this.provisionConfig(resource, providerParams, params, "strict.");
                resource.addFilter().name(this.getName() + STRICT_TRANSPORT_SUFFIX).role(this.getRole()).impl(STRICT_TRANSPORT_FILTER_CLASSNAME).params(params);
            }
        }
    }

    private void provisionConfig(ResourceDescriptor resource, Map<String, String> providerParams, List<FilterParamDescriptor> params, String prefix, boolean cutPrefix, boolean toLowerCase) {
        for (Map.Entry<String, String> entry : providerParams.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            String key = entry.getKey();
            if (cutPrefix) {
                key = key.substring(prefix.length());
            }
            if (toLowerCase) {
                key = key.toLowerCase(Locale.ROOT);
            }
            params.add(resource.createFilterParam().name(key).value(entry.getValue()));
        }
    }

    private void provisionConfig(ResourceDescriptor resource, Map<String, String> providerParams, List<FilterParamDescriptor> params, String prefix) {
        this.provisionConfig(resource, providerParams, params, prefix, false, true);
    }
}

