/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.knoxtoken;

import java.util.HashMap;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.knox.gateway.service.knoxtoken.PasscodeTokenResourceBase;
import org.apache.knox.gateway.service.knoxtoken.TokenResource;
import org.apache.knox.gateway.services.security.token.TokenMetadata;
import org.apache.knox.gateway.services.security.token.TokenMetadataType;
import org.apache.knox.gateway.util.JsonUtils;

@Path(value="apikey/api/v1/auth/key")
@Singleton
public class APIKeyResource
extends PasscodeTokenResourceBase {
    private static final String TYPE = "type";
    public static final String RESOURCE_PATH = "apikey/api/v1/auth/key";
    public static final String API_KEY = "api_key";
    public static final String KEY_ID = "key_id";
    public static final String PREFIX = "apikey.";

    @Override
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response doGet() {
        return super.doGet();
    }

    @Override
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Response doPost() {
        return super.doPost();
    }

    @Override
    protected void addArbitraryTokenMetadata(TokenMetadata tokenMetadata) {
        tokenMetadata.add(TYPE, TokenMetadataType.API_KEY.name());
        super.addArbitraryTokenMetadata(tokenMetadata);
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public Response getAuthenticationToken() {
        TokenResource.UserContext context = this.buildUserContext(this.request);
        Response response = this.checkForInvalidRequestResponse(context);
        if (response != null) {
            return response;
        }
        TokenResource.TokenResponseContext resp = this.getTokenResponse(context);
        if (resp.responseMap != null) {
            String passcode = (String)resp.responseMap.map.get("passcode");
            String tokenId = resp.responseMap.tokenId;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(KEY_ID, tokenId);
            map.put(API_KEY, passcode);
            this.addExpiryIfNotNever(map);
            String jsonResponse = JsonUtils.renderAsJsonString(map);
            return resp.responseBuilder.entity((Object)jsonResponse).build();
        }
        if (resp.responseStr != null) {
            return resp.responseBuilder.entity((Object)resp.responseStr).build();
        }
        return resp.responseBuilder.build();
    }
}

