/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.deploy;

import java.beans.Statement;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.GatewayServlet;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.DeploymentContextImpl;
import org.apache.knox.gateway.deploy.DeploymentException;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributor;
import org.apache.knox.gateway.deploy.ServiceDeploymentContributor;
import org.apache.knox.gateway.deploy.impl.ApplicationDeploymentContributor;
import org.apache.knox.gateway.descriptor.GatewayDescriptor;
import org.apache.knox.gateway.descriptor.GatewayDescriptorFactory;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.registry.ServiceRegistry;
import org.apache.knox.gateway.topology.Application;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;
import org.apache.knox.gateway.topology.Topology;
import org.apache.knox.gateway.topology.Version;
import org.apache.knox.gateway.util.ServiceDefinitionsLoader;
import org.apache.knox.gateway.util.Urls;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webcommon30.FilterType;
import org.jboss.shrinkwrap.descriptor.api.webcommon30.ServletType;

public abstract class DeploymentFactory {
    private static final JAXBContext jaxbContext = DeploymentFactory.getJAXBContext();
    private static final String SERVLET_NAME_SUFFIX = "-knox-gateway-servlet";
    private static final String FILTER_NAME_SUFFIX = "-knox-gateway-filter";
    private static final GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static GatewayServices gatewayServices;
    private static Map<String, Map<String, Map<Version, ServiceDeploymentContributor>>> SERVICE_CONTRIBUTOR_MAP;
    private static Set<ProviderDeploymentContributor> PROVIDER_CONTRIBUTORS;
    private static Map<String, Map<String, ProviderDeploymentContributor>> PROVIDER_CONTRIBUTOR_MAP;

    private static JAXBContext getJAXBContext() {
        HashMap<String, String> properties = new HashMap<String, String>(2);
        properties.put("eclipselink-oxm-xml", "org/apache/knox/gateway/topology/topology_binding-xml.xml");
        properties.put("eclipselink.media-type", "application/xml");
        try {
            return JAXBContext.newInstance((String)Topology.class.getPackage().getName(), (ClassLoader)Topology.class.getClassLoader(), properties);
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setGatewayServices(GatewayServices services) {
        gatewayServices = services;
    }

    static List<Application> findApplicationsByUrl(Topology topology, String url) {
        ArrayList<Application> foundApps = new ArrayList<Application>();
        if (topology != null) {
            url = Urls.trimLeadingAndTrailingSlash((String)url);
            Collection searchApps = topology.getApplications();
            if (searchApps != null) {
                block0: for (Application searchApp : searchApps) {
                    ArrayList<String> searchUrls = searchApp.getUrls();
                    if (searchUrls == null || searchUrls.isEmpty()) {
                        searchUrls = new ArrayList<String>(1);
                        searchUrls.add(searchApp.getName());
                    }
                    for (String searchUrl : searchUrls) {
                        if (!url.equalsIgnoreCase(Urls.trimLeadingAndTrailingSlash((String)searchUrl))) continue;
                        foundApps.add(searchApp);
                        continue block0;
                    }
                }
            }
        }
        return foundApps;
    }

    static void validateNoAppsWithDuplicateUrlsInTopology(Topology topology) {
        Collection apps;
        if (topology != null && (apps = topology.getApplications()) != null) {
            for (Application app : apps) {
                ArrayList<String> urls = app.getUrls();
                if (urls == null || urls.isEmpty()) {
                    urls = new ArrayList<String>(1);
                    urls.add(app.getName());
                }
                for (String url : urls) {
                    List<Application> dups = DeploymentFactory.findApplicationsByUrl(topology, url);
                    for (Application dup : dups) {
                        if (dup == app) continue;
                        throw new DeploymentException("Topology " + topology.getName() + " contains applications " + app.getName() + " and " + dup.getName() + " with the same url: " + url);
                    }
                }
            }
        }
    }

    static void validateNoAppsWithRootUrlsInServicesTopology(Topology topology) {
        List<Application> dups;
        Collection services;
        if (topology != null && (services = topology.getServices()) != null && !services.isEmpty() && !(dups = DeploymentFactory.findApplicationsByUrl(topology, "/")).isEmpty()) {
            throw new DeploymentException("Topology " + topology.getName() + " contains both services and an application " + dups.get(0).getName() + " with a root url.");
        }
    }

    static void validateTopology(Topology topology) {
        DeploymentFactory.validateNoAppsWithRootUrlsInServicesTopology(topology);
        DeploymentFactory.validateNoAppsWithDuplicateUrlsInTopology(topology);
    }

    public static EnterpriseArchive createDeployment(GatewayConfig config, Topology topology) {
        DeploymentFactory.validateTopology(topology);
        DeploymentFactory.loadStacksServiceContributors(config);
        Map<String, List<ProviderDeploymentContributor>> providers = DeploymentFactory.selectContextProviders(topology);
        Map<String, List<ServiceDeploymentContributor>> services = DeploymentFactory.selectContextServices(topology);
        Map<String, ServiceDeploymentContributor> applications = DeploymentFactory.selectContextApplications(config, topology);
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)topology.getName());
        ear.addAsResource(DeploymentFactory.toStringAsset(topology), "topology.xml");
        if (!services.isEmpty()) {
            WebArchive war = DeploymentFactory.createServicesDeployment(config, topology, providers, services);
            ear.addAsModule((Archive)war);
        }
        if (!applications.isEmpty()) {
            for (Map.Entry<String, ServiceDeploymentContributor> application : applications.entrySet()) {
                WebArchive war = DeploymentFactory.createApplicationDeployment(config, topology, providers, application);
                ear.addAsModule((Archive)war);
            }
        }
        return ear;
    }

    private static WebArchive createServicesDeployment(GatewayConfig config, Topology topology, Map<String, List<ProviderDeploymentContributor>> providers, Map<String, List<ServiceDeploymentContributor>> services) {
        DeploymentContext context = DeploymentFactory.createDeploymentContext(config, "/", topology, providers);
        DeploymentFactory.initialize(context, providers, services, null, config);
        DeploymentFactory.contribute(context, providers, services, null);
        DeploymentFactory.finish(context, providers, services, null);
        return context.getWebArchive();
    }

    public static WebArchive createApplicationDeployment(GatewayConfig config, Topology topology, Map<String, List<ProviderDeploymentContributor>> providers, Map.Entry<String, ServiceDeploymentContributor> application) {
        String appPath = "/" + Urls.trimLeadingAndTrailingSlash((String)application.getKey());
        DeploymentContext context = DeploymentFactory.createDeploymentContext(config, appPath, topology, providers);
        DeploymentFactory.initialize(context, providers, null, application, config);
        DeploymentFactory.contribute(context, providers, null, application);
        DeploymentFactory.finish(context, providers, null, application);
        return context.getWebArchive();
    }

    private static Asset toStringAsset(Topology topology) {
        String xml;
        StringWriter writer = new StringWriter();
        try {
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)topology, (Writer)writer);
            xml = writer.toString();
        }
        catch (JAXBException e) {
            throw new DeploymentException("Failed to marshall topology.", (Exception)((Object)e));
        }
        return new StringAsset(xml);
    }

    private static DeploymentContext createDeploymentContext(GatewayConfig config, String archivePath, Topology topology, Map<String, List<ProviderDeploymentContributor>> providers) {
        archivePath = Urls.encode((String)archivePath);
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)archivePath);
        WebAppDescriptor webAppDesc = (WebAppDescriptor)Descriptors.create(WebAppDescriptor.class);
        GatewayDescriptor gateway = GatewayDescriptorFactory.create();
        return new DeploymentContextImpl(config, topology, gateway, webArchive, webAppDesc, providers);
    }

    private static Map<String, List<ProviderDeploymentContributor>> selectContextProviders(Topology topology) {
        LinkedHashMap<String, List<ProviderDeploymentContributor>> providers = new LinkedHashMap<String, List<ProviderDeploymentContributor>>();
        DeploymentFactory.addMissingDefaultProviders(topology);
        DeploymentFactory.collectTopologyProviders(topology, providers);
        DeploymentFactory.collectDefaultProviders(providers);
        return providers;
    }

    private static void addMissingDefaultProviders(Topology topology) {
        Collection providers = topology.getProviders();
        HashMap<String, String> providerMap = new HashMap<String, String>();
        for (Provider provider : providers) {
            providerMap.put(provider.getRole(), provider.getName());
        }
        if (PROVIDER_CONTRIBUTOR_MAP.get("identity-assertion") != null && PROVIDER_CONTRIBUTOR_MAP.get("identity-assertion").keySet() != null && PROVIDER_CONTRIBUTOR_MAP.get("identity-assertion").keySet().contains("Default") && !providerMap.containsKey("identity-assertion")) {
            Provider idassertion = new Provider();
            idassertion.setRole("identity-assertion");
            idassertion.setName("Default");
            idassertion.setEnabled(true);
            providers.add(idassertion);
        }
    }

    private static void collectTopologyProviders(Topology topology, Map<String, List<ProviderDeploymentContributor>> defaults) {
        for (Provider provider : topology.getProviders()) {
            String role;
            Map<String, ProviderDeploymentContributor> nameMap;
            String name = provider.getName();
            if (name == null || (nameMap = PROVIDER_CONTRIBUTOR_MAP.get(role = provider.getRole())) == null) continue;
            ProviderDeploymentContributor contributor = nameMap.get(name);
            if (contributor == null && (nameMap = PROVIDER_CONTRIBUTOR_MAP.get("*")) != null) {
                contributor = nameMap.get(name);
            }
            if (contributor == null) continue;
            List<ProviderDeploymentContributor> list = defaults.get(role);
            if (list == null) {
                list = new ArrayList<ProviderDeploymentContributor>(1);
                defaults.put(role, list);
            }
            if (list.contains(contributor)) continue;
            list.add(contributor);
        }
    }

    private static void collectDefaultProviders(Map<String, List<ProviderDeploymentContributor>> defaults) {
        for (ProviderDeploymentContributor contributor : PROVIDER_CONTRIBUTORS) {
            String role = contributor.getRole();
            List list = defaults.computeIfAbsent(role, k -> new ArrayList());
            if (!list.isEmpty()) continue;
            list.add(contributor);
        }
    }

    private static Map<String, List<ServiceDeploymentContributor>> selectContextServices(Topology topology) {
        HashMap<String, List<ServiceDeploymentContributor>> defaults = new HashMap<String, List<ServiceDeploymentContributor>>();
        for (Service service : topology.getServices()) {
            List list;
            String role = service.getRole();
            ServiceDeploymentContributor contributor = DeploymentFactory.getServiceContributor(role, service.getName(), service.getVersion());
            if (contributor == null || (list = defaults.computeIfAbsent(role, k -> new ArrayList(1))).contains(contributor)) continue;
            list.add(contributor);
        }
        return defaults;
    }

    private static Map<String, ServiceDeploymentContributor> selectContextApplications(GatewayConfig config, Topology topology) {
        HashMap<String, ServiceDeploymentContributor> contributors = new HashMap<String, ServiceDeploymentContributor>();
        if (topology != null) {
            for (Application application : topology.getApplications()) {
                String name = application.getName();
                if (name == null || name.isEmpty()) {
                    throw new DeploymentException("Topologies cannot contain an application without a name.");
                }
                ApplicationDeploymentContributor contributor = new ApplicationDeploymentContributor(config, application);
                ArrayList<String> urls = application.getUrls();
                if (urls == null || urls.isEmpty()) {
                    urls = new ArrayList<String>(1);
                    urls.add("/" + name);
                }
                for (String url : urls) {
                    if ((url == null || url.isEmpty() || "/".equals(url)) && !topology.getServices().isEmpty()) {
                        throw new DeploymentException(String.format(Locale.ROOT, "Topologies with services cannot contain an application (%s) with a root url.", name));
                    }
                    contributors.put(url, (ServiceDeploymentContributor)contributor);
                }
            }
        }
        return contributors;
    }

    private static void initialize(DeploymentContext context, Map<String, List<ProviderDeploymentContributor>> providers, Map<String, List<ServiceDeploymentContributor>> services, Map.Entry<String, ServiceDeploymentContributor> applications, GatewayConfig gatewayConfig) {
        WebAppDescriptor wad = context.getWebAppDescriptor();
        String topoName = context.getTopology().getName();
        if (applications == null) {
            String servletName = topoName + SERVLET_NAME_SUFFIX;
            wad.createServlet().asyncSupported(Boolean.valueOf(gatewayConfig.isAsyncSupported())).servletName(servletName).servletClass(GatewayServlet.class.getName());
            wad.createServletMapping().servletName(servletName).urlPattern(new String[]{"/*"});
        } else {
            String filterName = topoName + FILTER_NAME_SUFFIX;
            wad.createFilter().asyncSupported(Boolean.valueOf(gatewayConfig.isAsyncSupported())).filterName(filterName).filterClass(GatewayServlet.class.getName());
            wad.createFilterMapping().filterName(filterName).urlPattern(new String[]{"/*"});
        }
        if (gatewayServices != null) {
            gatewayServices.initializeContribution(context);
        } else {
            log.gatewayServicesNotInitialized();
        }
        DeploymentFactory.initializeProviders(context, providers);
        DeploymentFactory.initializeServices(context, services);
        DeploymentFactory.initializeApplications(context, applications);
    }

    private static void initializeProviders(DeploymentContext context, Map<String, List<ProviderDeploymentContributor>> providers) {
        if (providers != null) {
            for (Map.Entry<String, List<ProviderDeploymentContributor>> entry : providers.entrySet()) {
                for (ProviderDeploymentContributor contributor : entry.getValue()) {
                    try {
                        DeploymentFactory.injectServices(contributor);
                        log.initializeProvider(contributor.getName(), contributor.getRole());
                        contributor.initializeContribution(context);
                    }
                    catch (Exception e) {
                        log.failedToInitializeContribution(e);
                        throw new DeploymentException("Failed to initialize contribution.", e);
                    }
                }
            }
        }
    }

    private static void initializeServices(DeploymentContext context, Map<String, List<ServiceDeploymentContributor>> services) {
        if (services != null) {
            for (Map.Entry<String, List<ServiceDeploymentContributor>> entry : services.entrySet()) {
                for (ServiceDeploymentContributor contributor : entry.getValue()) {
                    try {
                        DeploymentFactory.injectServices(contributor);
                        log.initializeService(contributor.getName(), contributor.getRole());
                        contributor.initializeContribution(context);
                    }
                    catch (Exception e) {
                        log.failedToInitializeContribution(e);
                        throw new DeploymentException("Failed to initialize contribution.", e);
                    }
                }
            }
        }
    }

    private static void initializeApplications(DeploymentContext context, Map.Entry<String, ServiceDeploymentContributor> application) {
        ServiceDeploymentContributor contributor;
        if (application != null && (contributor = application.getValue()) != null) {
            try {
                DeploymentFactory.injectServices(contributor);
                log.initializeApplication(contributor.getName());
                contributor.initializeContribution(context);
            }
            catch (Exception e) {
                log.failedToInitializeContribution(e);
                throw new DeploymentException("Failed to initialize application contribution.", e);
            }
        }
    }

    private static void injectServices(Object contributor) {
        if (gatewayServices != null) {
            for (ServiceType serviceType : gatewayServices.getServiceTypes()) {
                try {
                    Statement stmt = new Statement(contributor, "set" + serviceType.getServiceTypeName(), new Object[]{gatewayServices.getService(serviceType)});
                    stmt.execute();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (Exception e) {
                    log.failedToInjectService(serviceType.getServiceTypeName(), e);
                    throw new DeploymentException("Failed to inject service.", e);
                }
            }
        }
    }

    private static void contribute(DeploymentContext context, Map<String, List<ProviderDeploymentContributor>> providers, Map<String, List<ServiceDeploymentContributor>> services, Map.Entry<String, ServiceDeploymentContributor> applications) {
        Topology topology = context.getTopology();
        DeploymentFactory.contributeProviders(context, topology, providers);
        DeploymentFactory.contributeServices(context, topology, services);
        DeploymentFactory.contributeApplications(context, topology, applications);
    }

    private static void contributeProviders(DeploymentContext context, Topology topology, Map<String, List<ProviderDeploymentContributor>> providers) {
        for (Provider provider : topology.getProviders()) {
            ProviderDeploymentContributor contributor = DeploymentFactory.getProviderContributor(providers, provider.getRole(), provider.getName());
            if (contributor == null || !provider.isEnabled()) continue;
            try {
                log.contributeProvider(provider.getName(), provider.getRole());
                contributor.contributeProvider(context, provider);
            }
            catch (Exception e) {
                log.failedToContributeProvider(provider.getName(), provider.getRole(), e);
                throw new DeploymentException("Failed to contribute provider.", e);
            }
        }
    }

    private static void contributeServices(DeploymentContext context, Topology topology, Map<String, List<ServiceDeploymentContributor>> services) {
        if (services != null) {
            for (Service service : topology.getServices()) {
                ServiceDeploymentContributor contributor = DeploymentFactory.getServiceContributor(service.getRole(), service.getName(), service.getVersion());
                if (contributor == null) continue;
                try {
                    ServiceRegistry sr;
                    log.contributeService(service.getName(), service.getRole());
                    contributor.contributeService(context, service);
                    if (gatewayServices == null || (sr = (ServiceRegistry)gatewayServices.getService(ServiceType.SERVICE_REGISTRY_SERVICE)) == null) continue;
                    String regCode = sr.getRegistrationCode(topology.getName());
                    sr.registerService(regCode, topology.getName(), service.getRole(), service.getUrls());
                }
                catch (Exception e) {
                    log.failedToContributeService(service.getName(), service.getRole(), e);
                    throw new DeploymentException("Failed to contribute service.", e);
                }
            }
        }
    }

    private static void contributeApplications(DeploymentContext context, Topology topology, Map.Entry<String, ServiceDeploymentContributor> applications) {
        ServiceDeploymentContributor contributor;
        if (applications != null && (contributor = applications.getValue()) != null) {
            try {
                log.contributeApplication(contributor.getName());
                Application applicationDesc = topology.getApplication(applications.getKey());
                contributor.contributeService(context, (Service)applicationDesc);
            }
            catch (Exception e) {
                log.failedToInitializeContribution(e);
                throw new DeploymentException("Failed to contribution application.", e);
            }
        }
    }

    public static ProviderDeploymentContributor getProviderContributor(String role, String name) {
        ProviderDeploymentContributor contributor = null;
        Map<String, ProviderDeploymentContributor> nameMap = PROVIDER_CONTRIBUTOR_MAP.get(role);
        if (nameMap != null) {
            if (name != null) {
                contributor = nameMap.get(name);
            } else if (!nameMap.isEmpty()) {
                contributor = nameMap.values().iterator().next();
            }
        }
        return contributor;
    }

    public static ServiceDeploymentContributor getServiceContributor(String role, String name, Version version) {
        Map<Version, ServiceDeploymentContributor> versionMap;
        ServiceDeploymentContributor contributor = null;
        Map<String, Map<Version, ServiceDeploymentContributor>> nameMap = SERVICE_CONTRIBUTOR_MAP.get(role);
        if (nameMap != null && !nameMap.isEmpty() && (versionMap = name == null ? nameMap.values().iterator().next() : nameMap.get(name)) != null && !versionMap.isEmpty()) {
            contributor = version == null ? (ServiceDeploymentContributor)((TreeMap)versionMap).lastEntry().getValue() : versionMap.get(version);
        }
        return contributor;
    }

    private static void finish(DeploymentContext context, Map<String, List<ProviderDeploymentContributor>> providers, Map<String, List<ServiceDeploymentContributor>> services, Map.Entry<String, ServiceDeploymentContributor> application) {
        try {
            StringWriter writer = new StringWriter();
            GatewayDescriptorFactory.store(context.getGatewayDescriptor(), "xml", writer);
            context.getWebArchive().addAsWebInfResource((Asset)new StringAsset(writer.toString()), "gateway.xml");
            if (application == null) {
                String servletName = context.getTopology().getName() + SERVLET_NAME_SUFFIX;
                ServletType<WebAppDescriptor> servlet = DeploymentFactory.findServlet(context, servletName);
                if (servlet == null) {
                    throw new DeploymentException("Missing servlet " + servletName);
                }
                servlet.createInitParam().paramName("gatewayDescriptorLocation").paramValue("/WEB-INF/gateway.xml");
            } else {
                String servletName = context.getTopology().getName() + FILTER_NAME_SUFFIX;
                FilterType<WebAppDescriptor> filter = DeploymentFactory.findFilter(context, servletName);
                if (filter == null) {
                    throw new DeploymentException("Missing filter " + servletName);
                }
                filter.createInitParam().paramName("gatewayDescriptorLocation").paramValue("/WEB-INF/gateway.xml");
            }
            if (gatewayServices != null) {
                gatewayServices.finalizeContribution(context);
            }
            DeploymentFactory.finalizeProviders(context, providers);
            DeploymentFactory.finalizeServices(context, services);
            DeploymentFactory.finalizeApplications(context, application);
            DeploymentFactory.writeDeploymentDescriptor(context, application != null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void finalizeProviders(DeploymentContext context, Map<String, List<ProviderDeploymentContributor>> providers) {
        if (providers != null) {
            for (Map.Entry<String, List<ProviderDeploymentContributor>> entry : providers.entrySet()) {
                for (ProviderDeploymentContributor contributor : entry.getValue()) {
                    try {
                        log.finalizeProvider(contributor.getName(), contributor.getRole());
                        contributor.finalizeContribution(context);
                    }
                    catch (Exception e) {
                        log.failedToFinalizeContribution(e);
                        throw new DeploymentException("Failed to finish contribution.", e);
                    }
                }
            }
        }
    }

    private static void finalizeServices(DeploymentContext context, Map<String, List<ServiceDeploymentContributor>> services) {
        if (services != null) {
            for (Map.Entry<String, List<ServiceDeploymentContributor>> entry : services.entrySet()) {
                for (ServiceDeploymentContributor contributor : entry.getValue()) {
                    try {
                        log.finalizeService(contributor.getName(), contributor.getRole());
                        contributor.finalizeContribution(context);
                    }
                    catch (Exception e) {
                        log.failedToFinalizeContribution(e);
                        throw new DeploymentException("Failed to finish contribution.", e);
                    }
                }
            }
        }
    }

    private static void finalizeApplications(DeploymentContext context, Map.Entry<String, ServiceDeploymentContributor> application) {
        ServiceDeploymentContributor contributor;
        if (application != null && (contributor = application.getValue()) != null) {
            try {
                log.finalizeApplication(contributor.getName());
                contributor.finalizeContribution(context);
            }
            catch (Exception e) {
                log.failedToInitializeContribution(e);
                throw new DeploymentException("Failed to contribution application.", e);
            }
        }
    }

    private static void writeDeploymentDescriptor(DeploymentContext context, boolean override) {
        StringAsset webXmlAsset = new StringAsset(context.getWebAppDescriptor().exportAsString());
        if (override) {
            context.getWebArchive().addAsWebInfResource((Asset)webXmlAsset, "override-web.xml");
        } else {
            context.getWebArchive().setWebXML((Asset)webXmlAsset);
        }
    }

    public static ServletType<WebAppDescriptor> findServlet(DeploymentContext context, String name) {
        List servlets = context.getWebAppDescriptor().getAllServlet();
        for (ServletType servlet : servlets) {
            if (!name.equals(servlet.getServletName())) continue;
            return servlet;
        }
        return null;
    }

    public static FilterType<WebAppDescriptor> findFilter(DeploymentContext context, String name) {
        List filters = context.getWebAppDescriptor().getAllFilter();
        for (FilterType filter : filters) {
            if (!name.equals(filter.getFilterName())) continue;
            return filter;
        }
        return null;
    }

    private static void loadStacksServiceContributors(GatewayConfig config) {
        String stacks = config.getGatewayServicesDir();
        log.usingServicesDirectory(stacks);
        File stacksDir = new File(stacks);
        Set<ServiceDeploymentContributor> deploymentContributors = ServiceDefinitionsLoader.loadServiceDefinitionDeploymentContributors(stacksDir);
        DeploymentFactory.addServiceDeploymentContributors(deploymentContributors.iterator());
    }

    private static void loadServiceContributors() {
        SERVICE_CONTRIBUTOR_MAP = new HashMap<String, Map<String, Map<Version, ServiceDeploymentContributor>>>();
        ServiceLoader<ServiceDeploymentContributor> loader = ServiceLoader.load(ServiceDeploymentContributor.class);
        Iterator<ServiceDeploymentContributor> contributors = loader.iterator();
        DeploymentFactory.addServiceDeploymentContributors(contributors);
    }

    private static void addServiceDeploymentContributors(Iterator<ServiceDeploymentContributor> contributors) {
        while (contributors.hasNext()) {
            Map<Version, ServiceDeploymentContributor> versionMap;
            ServiceDeploymentContributor contributor = contributors.next();
            if (contributor.getName() == null) {
                log.ignoringServiceContributorWithMissingName(contributor.getClass().getName());
                continue;
            }
            if (contributor.getRole() == null) {
                log.ignoringServiceContributorWithMissingRole(contributor.getClass().getName());
                continue;
            }
            if (contributor.getVersion() == null) {
                log.ignoringServiceContributorWithMissingVersion(contributor.getClass().getName());
                continue;
            }
            Map<String, Map<Version, ServiceDeploymentContributor>> nameMap = SERVICE_CONTRIBUTOR_MAP.get(contributor.getRole());
            if (nameMap == null) {
                nameMap = new HashMap<String, Map<Version, ServiceDeploymentContributor>>();
                SERVICE_CONTRIBUTOR_MAP.put(contributor.getRole(), nameMap);
            }
            if ((versionMap = nameMap.get(contributor.getName())) == null) {
                versionMap = new TreeMap<Version, ServiceDeploymentContributor>();
                nameMap.put(contributor.getName(), versionMap);
            }
            versionMap.put(contributor.getVersion(), contributor);
        }
    }

    private static void loadProviderContributors() {
        HashSet<ProviderDeploymentContributor> set = new HashSet<ProviderDeploymentContributor>();
        HashMap<String, Map<String, ProviderDeploymentContributor>> roleMap = new HashMap<String, Map<String, ProviderDeploymentContributor>>();
        ServiceLoader<ProviderDeploymentContributor> loader = ServiceLoader.load(ProviderDeploymentContributor.class);
        for (ProviderDeploymentContributor contributor : loader) {
            if (contributor.getName() == null) {
                log.ignoringProviderContributorWithMissingName(contributor.getClass().getName());
                continue;
            }
            if (contributor.getRole() == null) {
                log.ignoringProviderContributorWithMissingRole(contributor.getClass().getName());
                continue;
            }
            set.add(contributor);
            HashMap<String, ProviderDeploymentContributor> nameMap = (HashMap<String, ProviderDeploymentContributor>)roleMap.get(contributor.getRole());
            if (nameMap == null) {
                nameMap = new HashMap<String, ProviderDeploymentContributor>();
                roleMap.put(contributor.getRole(), nameMap);
            }
            nameMap.put(contributor.getName(), contributor);
        }
        PROVIDER_CONTRIBUTORS = set;
        PROVIDER_CONTRIBUTOR_MAP = roleMap;
    }

    static ProviderDeploymentContributor getProviderContributor(Map<String, List<ProviderDeploymentContributor>> providers, String role, String name) {
        ProviderDeploymentContributor contributor = null;
        if (name == null) {
            List<ProviderDeploymentContributor> list = providers.get(role);
            if (list != null && !list.isEmpty()) {
                contributor = list.get(0);
            }
        } else {
            contributor = DeploymentFactory.getProviderContributor(role, name);
            if (contributor == null || !contributor.getRole().equals(role) || !contributor.getName().equals(name)) {
                throw new DeploymentException("Failed to contribute provider. Role: " + role + " Name: " + name + ". Please check the topology for errors in name and role and that the provider is on the classpath.");
            }
        }
        return contributor;
    }

    static {
        DeploymentFactory.loadServiceContributors();
        DeploymentFactory.loadProviderContributors();
    }
}

