/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGenerator;

public class ServiceModelGeneratorsHolder {
    private static final ServiceModelGeneratorsHolder INSTANCE = new ServiceModelGeneratorsHolder();
    private final Map<String, List<ServiceModelGenerator>> serviceModelGenerators = new HashMap<String, List<ServiceModelGenerator>>();

    private ServiceModelGeneratorsHolder() {
        ServiceLoader<ServiceModelGenerator> loader = ServiceLoader.load(ServiceModelGenerator.class);
        for (ServiceModelGenerator serviceModelGenerator : loader) {
            List smgList = this.serviceModelGenerators.computeIfAbsent(serviceModelGenerator.getServiceType(), k -> new ArrayList());
            smgList.add(serviceModelGenerator);
        }
    }

    public static ServiceModelGeneratorsHolder getInstance() {
        return INSTANCE;
    }

    public List<ServiceModelGenerator> getServiceModelGenerators(String serviceType) {
        return this.serviceModelGenerators.get(serviceType);
    }
}

