/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.plang;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.knox.gateway.identityasserter.regex.filter.RegexTemplate;
import org.apache.knox.gateway.plang.AbstractSyntaxTree;
import org.apache.knox.gateway.plang.Arity;
import org.apache.knox.gateway.plang.InterpreterException;
import org.apache.knox.gateway.plang.TypeException;
import org.apache.knox.gateway.plang.UndefinedSymbolException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Interpreter {
    private static final Logger LOG = LogManager.getLogger(Interpreter.class);
    private final Map<String, SpecialForm> specialForms = new HashMap<String, SpecialForm>();
    private final Map<String, Func> functions = new HashMap<String, Func>();
    private final Map<String, Object> constants = new HashMap<String, Object>();

    public Interpreter() {
        this.addSpecialForm(Arity.min(1), "or", args -> args.stream().anyMatch(each -> (Boolean)this.eval((AbstractSyntaxTree)each)));
        this.addSpecialForm(Arity.min(1), "and", args -> args.stream().allMatch(each -> (Boolean)this.eval((AbstractSyntaxTree)each)));
        this.addSpecialForm(Arity.between(2, 3), "if", args -> {
            if (((Boolean)this.eval((AbstractSyntaxTree)args.get(0))).booleanValue()) {
                return this.eval((AbstractSyntaxTree)args.get(1));
            }
            if (args.size() == 3) {
                return this.eval((AbstractSyntaxTree)args.get(2));
            }
            return null;
        });
        this.addFunction("not", Arity.UNARY, args -> (Boolean)args.get(0) == false);
        this.addFunction("=", Arity.BINARY, args -> Interpreter.equalTo(args.get(0), args.get(1)));
        this.addFunction("!=", Arity.BINARY, args -> !Interpreter.equalTo(args.get(0), args.get(1)));
        this.addFunction("<", Arity.BINARY, args -> ((Number)args.get(0)).doubleValue() < ((Number)args.get(1)).doubleValue());
        this.addFunction("<=", Arity.BINARY, args -> ((Number)args.get(0)).doubleValue() <= ((Number)args.get(1)).doubleValue());
        this.addFunction(">", Arity.BINARY, args -> ((Number)args.get(0)).doubleValue() > ((Number)args.get(1)).doubleValue());
        this.addFunction(">=", Arity.BINARY, args -> ((Number)args.get(0)).doubleValue() >= ((Number)args.get(1)).doubleValue());
        this.addFunction("+", Arity.BINARY, args -> this.add((Number)args.get(0), (Number)args.get(1)));
        this.addFunction("-", Arity.BINARY, args -> this.sub((Number)args.get(0), (Number)args.get(1)));
        this.addFunction("*", Arity.BINARY, args -> this.mul((Number)args.get(0), (Number)args.get(1)));
        this.addFunction("/", Arity.BINARY, args -> this.div((Number)args.get(0), (Number)args.get(1)));
        this.addFunction("match", Arity.BINARY, args -> args.get(0) instanceof String ? Pattern.matches((String)args.get(1), (String)args.get(0)) : ((List)args.get(0)).stream().anyMatch(each -> Pattern.matches((String)args.get(1), each)));
        this.addFunction("size", Arity.UNARY, args -> ((Collection)args.get(0)).size());
        this.addFunction("empty", Arity.UNARY, args -> ((Collection)args.get(0)).isEmpty());
        this.addFunction("username", Arity.UNARY, args -> this.constants.get("username").equals(args.get(0)));
        this.addFunction("member", Arity.UNARY, args -> ((Collection)this.constants.get("groups")).contains((String)args.get(0)));
        this.addFunction("lowercase", Arity.UNARY, args -> ((String)args.get(0)).toLowerCase(Locale.getDefault()));
        this.addFunction("uppercase", Arity.UNARY, args -> ((String)args.get(0)).toUpperCase(Locale.getDefault()));
        this.addFunction("concat", Arity.min(1), args -> args.stream().map(Object::toString).collect(Collectors.joining()));
        this.addFunction("substr", Arity.min(2), args -> args.size() == 2 ? ((String)args.get(0)).substring(((Number)args.get(1)).intValue()) : ((String)args.get(0)).substring(((Number)args.get(1)).intValue(), ((Number)args.get(2)).intValue()));
        this.addFunction("strlen", Arity.UNARY, args -> ((String)args.get(0)).length());
        this.addFunction("starts-with", Arity.BINARY, args -> ((String)args.get(0)).startsWith((String)args.get(1)));
        this.addFunction("ends-with", Arity.BINARY, args -> ((String)args.get(0)).endsWith((String)args.get(1)));
        this.addFunction("contains", Arity.BINARY, args -> ((String)args.get(1)).contains((String)args.get(0)));
        this.addFunction("index-of", Arity.BINARY, args -> ((String)args.get(1)).indexOf((String)args.get(0)));
        this.addFunction("regex-template", Arity.between(3, 5), args -> {
            String str = (String)args.get(0);
            String regex = (String)args.get(1);
            String template = (String)args.get(2);
            if (args.size() == 3) {
                return new RegexTemplate(regex, template, null, false).apply(str);
            }
            boolean useOriginalOnLookupFailure = args.size() >= 5 && (Boolean)args.get(4) != false;
            return new RegexTemplate(regex, template, (Map)args.get(3), useOriginalOnLookupFailure).apply(str);
        });
        this.addFunction("print", Arity.min(1), args -> {
            args.forEach(arg -> LOG.info(arg == null ? "null" : arg.toString()));
            return false;
        });
        this.addFunction("hash", Arity.even(), args -> {
            HashMap map = new HashMap();
            for (int i = 0; i < args.size() - 1; i += 2) {
                map.put(args.get(i), args.get(i + 1));
            }
            return map;
        });
        this.addFunction("at", Arity.BINARY, args -> ((Map)args.get(1)).get(args.get(0)));
        this.constants.put("true", true);
        this.constants.put("false", false);
    }

    private Number add(Number a, Number b) {
        if (Interpreter.isFloatingPoint(a) && Interpreter.isFloatingPoint(b)) {
            return a.doubleValue() + b.doubleValue();
        }
        if (Interpreter.isInteger(a) && Interpreter.isInteger(b)) {
            return a.longValue() + b.longValue();
        }
        if (Interpreter.isInteger(a) && Interpreter.isFloatingPoint(b)) {
            return (double)a.longValue() + b.doubleValue();
        }
        if (Interpreter.isFloatingPoint(a) && Interpreter.isInteger(b)) {
            return a.doubleValue() + (double)b.longValue();
        }
        throw new TypeException("Unsupported operands: (+ " + a + " " + b + ")", null);
    }

    private Number sub(Number a, Number b) {
        if (Interpreter.isFloatingPoint(a) && Interpreter.isFloatingPoint(b)) {
            return a.doubleValue() - b.doubleValue();
        }
        if (Interpreter.isInteger(a) && Interpreter.isInteger(b)) {
            return a.longValue() - b.longValue();
        }
        if (Interpreter.isInteger(a) && Interpreter.isFloatingPoint(b)) {
            return (double)a.longValue() - b.doubleValue();
        }
        if (Interpreter.isFloatingPoint(a) && Interpreter.isInteger(b)) {
            return a.doubleValue() - (double)b.longValue();
        }
        throw new TypeException("Unsupported operands: (- " + a + " " + b + ")", null);
    }

    private Number mul(Number a, Number b) {
        if (Interpreter.isFloatingPoint(a) && Interpreter.isFloatingPoint(b)) {
            return a.doubleValue() * b.doubleValue();
        }
        if (Interpreter.isInteger(a) && Interpreter.isInteger(b)) {
            return a.longValue() * b.longValue();
        }
        if (Interpreter.isInteger(a) && Interpreter.isFloatingPoint(b)) {
            return (double)a.longValue() * b.doubleValue();
        }
        if (Interpreter.isFloatingPoint(a) && Interpreter.isInteger(b)) {
            return a.doubleValue() * (double)b.longValue();
        }
        throw new TypeException("Unsupported operands: (* " + a + " " + b + ")", null);
    }

    private Number div(Number a, Number b) {
        return a.doubleValue() / b.doubleValue();
    }

    private static boolean isInteger(Number n) {
        return n instanceof Long || n instanceof Integer;
    }

    private static boolean isFloatingPoint(Number n) {
        return n instanceof Double || n instanceof Float;
    }

    private static boolean equalTo(Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            return Double.compare(((Number)a).doubleValue(), ((Number)b).doubleValue()) == 0;
        }
        return a.equals(b);
    }

    public void addConstant(String name, Object value) {
        this.constants.put(name, value);
    }

    private void addSpecialForm(Arity arity, String name, SpecialForm form) {
        this.specialForms.put(name, parameters -> {
            arity.check(name, parameters);
            return form.call(parameters);
        });
    }

    public void addFunction(String name, Arity arity, Func func) {
        this.functions.put(name, parameters -> {
            arity.check(name, parameters);
            return func.call(parameters);
        });
    }

    public Object eval(AbstractSyntaxTree ast) {
        try {
            if (ast == null) {
                return null;
            }
            if (ast.isAtom()) {
                return ast.isStr() ? ast.strValue() : (ast.isNumber() ? ast.numValue() : this.lookupConstant(ast));
            }
            if (ast.isFunction()) {
                SpecialForm specialForm = this.specialForms.get(ast.functionName());
                if (specialForm != null) {
                    return specialForm.call(ast.functionParameters());
                }
                Func func = this.functions.get(ast.functionName());
                if (func == null) {
                    throw new UndefinedSymbolException(ast.functionName(), "function");
                }
                return func.call(ast.functionParameters().stream().map(this::eval).collect(Collectors.toList()));
            }
            throw new InterpreterException("Unknown token: " + ast.token());
        }
        catch (ClassCastException e) {
            throw new TypeException("Type error at: " + ast, e);
        }
    }

    private Object lookupConstant(AbstractSyntaxTree ast) {
        Object var = this.constants.get(ast.token());
        if (var == null) {
            throw new UndefinedSymbolException(ast.token(), "variable");
        }
        return var;
    }

    private static interface SpecialForm {
        public Object call(List<AbstractSyntaxTree> var1);
    }

    public static interface Func {
        public Object call(List<Object> var1);
    }
}

