/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.normalizers.NumericNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumericStringComparator
extends LdapComparator<String> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(NumericStringComparator.class);

    public NumericStringComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(String backendValue, String assertValue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_13754_COMPARING_NUMERIC_STRING_ORDERING, (Object[])new Object[]{backendValue, assertValue}));
        }
        if (backendValue == assertValue) {
            return 0;
        }
        if (backendValue == null || assertValue == null) {
            return backendValue == null ? -1 : 1;
        }
        NumericNormalizer normalizer = new NumericNormalizer();
        try {
            backendValue = normalizer.normalize(backendValue);
        }
        catch (LdapException le) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_13724_INVALID_VALUE, (Object[])new Object[]{backendValue}), le);
        }
        try {
            assertValue = normalizer.normalize(assertValue);
        }
        catch (LdapException le) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_13724_INVALID_VALUE, (Object[])new Object[]{assertValue}), le);
        }
        return backendValue.compareTo(assertValue);
    }
}

