/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.table;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class KnoxShellTableFileUtils {
    public static void persistToFile(String filePath, String content) throws IOException {
        Path jsonFilePath = Paths.get(filePath, new String[0]);
        if (!Files.exists(jsonFilePath.getParent(), new LinkOption[0])) {
            Files.createDirectories(jsonFilePath.getParent(), new FileAttribute[0]);
        }
        Files.deleteIfExists(jsonFilePath);
        Files.createFile(jsonFilePath, new FileAttribute[0]);
        KnoxShellTableFileUtils.setPermissions(jsonFilePath);
        Files.write(jsonFilePath, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static void setPermissions(Path path) throws IOException {
        path.toFile().setReadable(false, false);
        path.toFile().setWritable(false, false);
        path.toFile().setExecutable(false, false);
        path.toFile().setReadable(true, true);
        path.toFile().setWritable(true, true);
    }
}

