/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.topology.impl;

import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;

public class GatewayStatusService
implements Service {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private final Set<String> deployedTopologies = new HashSet<String>();
    private Set<String> topologyNamesToCheck = new HashSet<String>();
    private GatewayConfig config;

    public synchronized void onTopologyReady(String topologyName) {
        this.deployedTopologies.add(topologyName);
    }

    public synchronized boolean status() {
        if (this.topologyNamesToCheck.isEmpty()) {
            LOG.noTopologiesToCheck();
            return false;
        }
        HashSet<String> missing = new HashSet<String>(this.topologyNamesToCheck);
        missing.removeAll(this.deployedTopologies);
        LOG.checkingGatewayStatus(this.deployedTopologies, missing);
        return missing.isEmpty();
    }

    public synchronized void initTopologiesToCheck() {
        Set healthCheckTopologies = this.config.getHealthCheckTopologies();
        if (healthCheckTopologies.isEmpty()) {
            this.topologyNamesToCheck = this.collectTopologies(this.config);
            LOG.collectedTopologiesForHealthCheck(this.topologyNamesToCheck);
        } else {
            this.topologyNamesToCheck = healthCheckTopologies;
        }
        LOG.startingStatusMonitor(this.topologyNamesToCheck);
    }

    public Set<String> collectTopologies(GatewayConfig config) {
        HashSet<String> result = new HashSet<String>();
        this.collectFiles(result, config.getGatewayTopologyDir(), ".xml");
        this.collectFiles(result, config.getGatewayDescriptorsDir(), ".json");
        return result;
    }

    private void collectFiles(Set<String> result, String directory, String extension) {
        File[] files = new File(directory).getAbsoluteFile().listFiles((dir, name) -> name.toLowerCase(Locale.ROOT).endsWith(extension));
        if (files != null) {
            for (File file : files) {
                result.add(FilenameUtils.getBaseName((String)file.getName()));
            }
        }
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.config = config;
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
    }
}

