/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.provider.federation.jwt.filter;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.provider.federation.jwt.JWTMessages;
import org.apache.knox.gateway.provider.federation.jwt.filter.AbstractJWTFilter;
import org.apache.knox.gateway.security.PrimaryPrincipal;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTToken;
import org.apache.knox.gateway.session.SessionInvalidators;
import org.apache.knox.gateway.util.AuthFilterUtils;
import org.apache.knox.gateway.util.CertificateUtils;
import org.apache.knox.gateway.util.CookieUtils;
import org.apache.knox.gateway.util.Urls;
import org.eclipse.jetty.http.MimeTypes;

public class SSOCookieFederationFilter
extends AbstractJWTFilter {
    private static final JWTMessages LOGGER = (JWTMessages)MessagesFactory.get(JWTMessages.class);
    public static final String XHR_HEADER = "X-Requested-With";
    public static final String XHR_VALUE = "XMLHttpRequest";
    private static final String GATEWAY_PATH = "gateway.path";
    public static final String SSO_COOKIE_NAME = "sso.cookie.name";
    public static final String SSO_EXPECTED_AUDIENCES = "sso.expected.audiences";
    public static final String SSO_AUTHENTICATION_PROVIDER_URL = "sso.authentication.provider.url";
    public static final String SSO_VERIFICATION_PEM = "sso.token.verification.pem";
    public static final String SSO_IDLE_TIMEOUT_SECONDS = "sso.idle.timeout.seconds";
    public static final String X_FORWARDED_HOST = "X-Forwarded-Host";
    public static final String X_FORWARDED_PORT = "X-Forwarded-Port";
    public static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
    public static final String SHOULD_USE_ORIGINAL_URL_FROM_HEADER = "sso.use.original.url.from.header";
    public static final String X_ORIGINAL_URL = "X-Original-URL";
    public static final String X_ORIGINAL_URL_HEADER_NAME = "sso.original.url.from.header.name";
    private static final boolean DEFAULT_SHOULD_USE_ORIGINAL_URL_FROM_HEADER = false;
    public static final String VERIFY_ORIGINAL_URL_FROM_HEADER_DOMAIN = "sso.original.url.from.header.verify.domain";
    private static final boolean DEFAULT_VERIFY_ORIGINAL_URL_FROM_HEADER_DOMAIN = false;
    public static final String VERIFY_ORIGINAL_URL_FROM_HEADER_DOMAIN_WHITELIST = "sso.original.url.from.header.domain.whitelist";
    private static final String ORIGINAL_URL_QUERY_PARAM = "originalUrl=";
    public static final String DEFAULT_SSO_COOKIE_NAME = "hadoop-jwt";
    private static final String SSO_UNAUTHENTICATED_PATHS_PARAM = "sso.unauthenticated.path.list";
    private static final String DEFAULT_SSO_UNAUTHENTICATED_PATHS_PARAM = "/favicon.ico;/knoxtoken/api/v1/jwks.json";
    private String cookieName;
    private String authenticationProviderUrl;
    private String gatewayPath;
    private final Set<String> unAuthenticatedPaths = new HashSet<String>(20);
    private boolean shouldUseOriginalUrlFromHeader = false;
    private boolean verifyOriginalUrlFromHeaderDomain = false;
    private final List<String> verifyOriginalUrlFromHeaderDomainWhitelist = new ArrayList<String>();
    private String originalUrlHeaderName;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String shouldUseOriginalUrlFromHeaderFilterParam;
        String verificationPEM;
        String expectedAudiences;
        super.init(filterConfig);
        this.cookieName = filterConfig.getInitParameter(SSO_COOKIE_NAME);
        if (this.cookieName == null) {
            this.cookieName = DEFAULT_SSO_COOKIE_NAME;
        }
        if ((expectedAudiences = filterConfig.getInitParameter(SSO_EXPECTED_AUDIENCES)) != null) {
            this.audiences = this.parseExpectedAudiences(expectedAudiences);
        }
        this.authenticationProviderUrl = filterConfig.getInitParameter(SSO_AUTHENTICATION_PROVIDER_URL);
        if (this.authenticationProviderUrl == null) {
            LOGGER.missingAuthenticationProviderUrlConfiguration();
        }
        if ((verificationPEM = filterConfig.getInitParameter(SSO_VERIFICATION_PEM)) != null) {
            this.publicKey = CertificateUtils.parseRSAPublicKey((String)verificationPEM);
        }
        String unAuthPathString = filterConfig.getInitParameter(SSO_UNAUTHENTICATED_PATHS_PARAM);
        AuthFilterUtils.addUnauthPaths(this.unAuthenticatedPaths, (String)unAuthPathString, (String)DEFAULT_SSO_UNAUTHENTICATED_PATHS_PARAM);
        this.setGatewayPath(filterConfig);
        String ssoIdleTimeoutSeconds = filterConfig.getInitParameter(SSO_IDLE_TIMEOUT_SECONDS);
        if (ssoIdleTimeoutSeconds != null) {
            this.idleTimeoutSeconds = Long.parseLong(ssoIdleTimeoutSeconds);
            LOGGER.configuredIdleTimeout(this.idleTimeoutSeconds, this.topologyName);
        }
        this.shouldUseOriginalUrlFromHeader = (shouldUseOriginalUrlFromHeaderFilterParam = filterConfig.getInitParameter(SHOULD_USE_ORIGINAL_URL_FROM_HEADER)) != null ? Boolean.parseBoolean(shouldUseOriginalUrlFromHeaderFilterParam) : false;
        if (this.shouldUseOriginalUrlFromHeader) {
            String verifyOriginalUrlFromHeaderDomainFilterParam;
            this.originalUrlHeaderName = filterConfig.getInitParameter(X_ORIGINAL_URL_HEADER_NAME);
            if (this.originalUrlHeaderName == null) {
                this.originalUrlHeaderName = X_ORIGINAL_URL;
            }
            this.verifyOriginalUrlFromHeaderDomain = (verifyOriginalUrlFromHeaderDomainFilterParam = filterConfig.getInitParameter(VERIFY_ORIGINAL_URL_FROM_HEADER_DOMAIN)) != null ? Boolean.parseBoolean(verifyOriginalUrlFromHeaderDomainFilterParam) : false;
            String verifyOriginalUrlDomainWhitelistParam = filterConfig.getInitParameter(VERIFY_ORIGINAL_URL_FROM_HEADER_DOMAIN_WHITELIST);
            if (this.verifyOriginalUrlFromHeaderDomain && verifyOriginalUrlDomainWhitelistParam != null) {
                String[] domains;
                for (String domain : domains = verifyOriginalUrlDomainWhitelistParam.split(",")) {
                    String trimmedDomain = domain.trim();
                    if (trimmedDomain.isEmpty()) continue;
                    this.verifyOriginalUrlFromHeaderDomainWhitelist.add(trimmedDomain);
                }
            }
        }
        this.configureExpectedParameters(filterConfig);
    }

    private void setGatewayPath(FilterConfig filterConfig) {
        this.gatewayPath = filterConfig.getInitParameter(GATEWAY_PATH);
        if (this.gatewayPath == null || this.gatewayPath.isEmpty()) {
            GatewayConfig gatewayConfig;
            GatewayConfig gatewayConfig2 = gatewayConfig = filterConfig.getServletContext() == null ? null : (GatewayConfig)filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.config");
            if (gatewayConfig != null) {
                this.gatewayPath = gatewayConfig.getGatewayPath();
            }
        }
    }

    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (AuthFilterUtils.doesRequestContainUnauthPath(this.unAuthenticatedPaths, (ServletRequest)request)) {
            Subject sub = new Subject();
            sub.getPrincipals().add((Principal)new PrimaryPrincipal("anonymous"));
            LOGGER.unauthenticatedPathBypass(req.getRequestURI(), this.unAuthenticatedPaths.toString());
            this.continueWithEstablishedSecurityContext(sub, req, res, chain);
            return;
        }
        List ssoCookies = CookieUtils.getCookiesForName((HttpServletRequest)req, (String)this.cookieName);
        if (ssoCookies.isEmpty()) {
            if ("OPTIONS".equals(req.getMethod())) {
                Subject sub = new Subject();
                sub.getPrincipals().add((Principal)new PrimaryPrincipal("anonymous"));
                this.continueWithEstablishedSecurityContext(sub, req, res, chain);
            } else {
                this.sendRedirectToLoginURL(req, res);
            }
        } else {
            for (Cookie ssoCookie : ssoCookies) {
                String wireToken = ssoCookie.getValue();
                try {
                    JWTToken token = new JWTToken(wireToken);
                    if (!this.validateToken(req, res, chain, (JWT)token)) continue;
                    Subject subject = this.createSubjectFromToken((JWT)token);
                    request.setAttribute("currentKnoxSsoCookieTokenId", (Object)token.getClaim("knox.id"));
                    this.continueWithEstablishedSecurityContext(subject, req, res, chain);
                    return;
                }
                catch (ParseException | UnknownTokenException throwable) {
                }
            }
            if (res != null && !res.isCommitted() && res.getHeader("Location") == null) {
                this.sendRedirectToLoginURL(req, res);
            }
        }
    }

    private void sendRedirectToLoginURL(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String loginURL = this.constructLoginURL(request);
        LOGGER.sendRedirectToLoginURL(loginURL);
        response.sendRedirect(loginURL);
    }

    @Override
    protected void handleValidationError(HttpServletRequest request, HttpServletResponse response, int status, String error) throws IOException {
        if (this.isInvalidSsoCookie(error)) {
            LOGGER.invalidSsoCookie();
            response.setStatus(401);
            this.removeAuthenticationToken(request, response);
            SessionInvalidators.KNOX_SSO_INVALIDATOR.getSessionInvalidators().forEach(sessionInvalidator -> sessionInvalidator.onAuthenticationError(request, response));
            if (AuthFilterUtils.shouldDoGlobalLogout((HttpServletRequest)request)) {
                String redirectTo = this.constructGlobalLogoutUrl(request);
                LOGGER.sendRedirectToLogoutURL(redirectTo);
                response.setHeader("Location", redirectTo);
                response.sendRedirect(redirectTo);
                return;
            }
        }
        if (request.getHeader(XHR_HEADER) != null && request.getHeader(XHR_HEADER).equalsIgnoreCase(XHR_VALUE)) {
            response.setStatus(401);
            response.setContentType(MimeTypes.Type.TEXT_PLAIN.toString());
            if (error != null && !error.isEmpty()) {
                byte[] data = error.getBytes(StandardCharsets.UTF_8);
                response.setContentLength(data.length);
                response.getOutputStream().write(data);
            }
        } else {
            String loginURL = this.constructLoginURL(request);
            response.sendRedirect(loginURL);
        }
    }

    private boolean isInvalidSsoCookie(String error) {
        return error != null && error.startsWith("Token ") && (error.endsWith(" is disabled") || error.endsWith(" exceeded idle timeout"));
    }

    private String constructGlobalLogoutUrl(HttpServletRequest request) {
        StringBuilder logoutUrlBuilder = new StringBuilder(this.deriveDefaultAuthenticationProviderUrl(request, true));
        logoutUrlBuilder.append('&').append(ORIGINAL_URL_QUERY_PARAM).append(this.deriveDefaultAuthenticationProviderUrl(request, false));
        return logoutUrlBuilder.toString();
    }

    protected String constructLoginURL(HttpServletRequest request) {
        String providerURL = null;
        String delimiter = "?";
        providerURL = this.authenticationProviderUrl == null ? this.deriveDefaultAuthenticationProviderUrl(request) : this.authenticationProviderUrl;
        if (providerURL.contains("?")) {
            delimiter = "&";
        }
        if (this.shouldUseOriginalUrlFromHeader && request.getHeader(this.originalUrlHeaderName) != null && !request.getHeader(this.originalUrlHeaderName).trim().isEmpty()) {
            String originalUrlFromHeader = request.getHeader(this.originalUrlHeaderName);
            LOGGER.usingOriginalUrlFromHeader(originalUrlFromHeader);
            if (this.verifyOriginalUrlFromHeaderDomain) {
                try {
                    URL originalUrl = new URL(originalUrlFromHeader);
                    String originalDomain = originalUrl.getHost();
                    if (!this.verifyOriginalUrlFromHeaderDomainWhitelist.contains(originalDomain)) {
                        LOGGER.invalidOriginalUrlDomain(originalDomain);
                        throw new IllegalArgumentException("Original URL domain '" + originalDomain + "' is not in the allowed whitelist");
                    }
                }
                catch (MalformedURLException e) {
                    LOGGER.malformedOriginalUrlDomain(originalUrlFromHeader);
                    throw new IllegalArgumentException("Invalid original URL format: " + originalUrlFromHeader, e);
                }
            }
            LOGGER.originalHeaderURLForwarding(originalUrlFromHeader, this.originalUrlHeaderName);
            return providerURL + delimiter + ORIGINAL_URL_QUERY_PARAM + originalUrlFromHeader;
        }
        return providerURL + delimiter + ORIGINAL_URL_QUERY_PARAM + request.getRequestURL().append(this.getOriginalQueryString(request));
    }

    public String deriveDefaultAuthenticationProviderUrl(HttpServletRequest request) {
        return this.deriveDefaultAuthenticationProviderUrl(request, false);
    }

    public String deriveDefaultAuthenticationProviderUrl(HttpServletRequest request, boolean logout) {
        String providerURL = null;
        try {
            URL url = new URL(request.getRequestURL().toString());
            String scheme = url.getProtocol();
            String host = url.getHost();
            int port = url.getPort();
            StringBuilder sb = new StringBuilder(scheme);
            sb.append("://").append(host);
            if (!host.contains(":") && port != -1) {
                sb.append(':').append(port);
            }
            sb.append('/').append(this.gatewayPath).append(logout ? "/knoxsso/knoxauth/logout.jsp?autoGlobalLogout=1" : "/knoxsso/api/v1/websso");
            providerURL = sb.toString();
        }
        catch (MalformedURLException e) {
            LOGGER.failedToDeriveAuthenticationProviderUrl(e);
        }
        return providerURL;
    }

    private String getOriginalQueryString(HttpServletRequest request) {
        String originalQueryString = request.getQueryString();
        return originalQueryString == null ? "" : "?" + originalQueryString;
    }

    private void removeAuthenticationToken(HttpServletRequest request, HttpServletResponse response) {
        Cookie c = new Cookie(this.cookieName, null);
        c.setMaxAge(0);
        c.setPath("/");
        try {
            String domainName = Urls.getDomainName((String)request.getRequestURL().toString(), null);
            if (domainName != null) {
                c.setDomain(domainName);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        response.addCookie(c);
    }
}

