/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.knoxtoken;

import java.util.HashMap;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.knox.gateway.service.knoxtoken.PasscodeTokenResourceBase;
import org.apache.knox.gateway.service.knoxtoken.ServletContextWrapper;
import org.apache.knox.gateway.service.knoxtoken.TokenResource;
import org.apache.knox.gateway.util.JsonUtils;

@Singleton
@Path(value="/{serviceName:.*}/v1/{oauthSegment:(oauth|token)}{path:(/tokens)?}")
public class OAuthResource
extends PasscodeTokenResourceBase {
    static final String RESOURCE_PATH = "/{serviceName:.*}/v1/{oauthSegment:(oauth|token)}{path:(/tokens)?}";
    public static final String ISSUED_TOKEN_TYPE = "issued_token_type";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String ISSUED_TOKEN_TYPE_ACCESS_TOKEN_VALUE = "urn:ietf:params:oauth:token-type:access_token";

    @Override
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response doGet() {
        return super.doGet();
    }

    @Override
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Response doPost() {
        return super.doPost();
    }

    @Override
    protected ServletContext wrapContextForDefaultParams(ServletContext context) throws ServletException {
        ServletContextWrapper wrapperContext = new ServletContextWrapper(context);
        this.setupTokenStateService(wrapperContext);
        return wrapperContext;
    }

    @Override
    public Response getAuthenticationToken() {
        Response response = this.enforceClientCertIfRequired();
        if (response != null) {
            return response;
        }
        response = this.onlyAllowGroupsToBeAddedWhenEnabled();
        if (response != null) {
            return response;
        }
        TokenResource.UserContext context = this.buildUserContext(this.request);
        response = this.enforceTokenLimitsAsRequired(context.userName);
        if (response != null) {
            return response;
        }
        TokenResource.TokenResponseContext resp = this.getTokenResponse(context);
        if (resp.responseMap != null) {
            String accessToken = resp.responseMap.accessToken;
            String passcode = resp.responseMap.passcode;
            String tokenType = (String)resp.responseMap.map.get("token_type");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("access_token", accessToken);
            map.put("token_type", tokenType);
            map.put("expires_in", this.getTokenLifetimeInSeconds());
            map.put(ISSUED_TOKEN_TYPE, ISSUED_TOKEN_TYPE_ACCESS_TOKEN_VALUE);
            map.put(REFRESH_TOKEN, passcode);
            String jsonResponse = JsonUtils.renderAsJsonString(map);
            return resp.responseBuilder.entity((Object)jsonResponse).build();
        }
        if (resp.responseStr != null) {
            return resp.responseBuilder.entity((Object)resp.responseStr).build();
        }
        return resp.responseBuilder.build();
    }
}

