/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiConfigStalenessStatus;
import com.cloudera.api.swagger.model.ApiHealthSummary;
import com.cloudera.api.swagger.model.ApiMapEntry;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceRef;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="ApiDataContext is the persistent storage/services context exported by the base cluster to be consumed by the compute cluster.")
public class ApiDataContext {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="nameservice")
    private String nameservice = null;
    @SerializedName(value="createdTime")
    private String createdTime = null;
    @SerializedName(value="lastModifiedTime")
    private String lastModifiedTime = null;
    @SerializedName(value="services")
    private List<ApiServiceRef> services = null;
    @SerializedName(value="servicesDetails")
    private List<ApiService> servicesDetails = null;
    @SerializedName(value="supportedServiceTypes")
    private List<String> supportedServiceTypes = null;
    @SerializedName(value="allowedClusterVersions")
    private List<ApiMapEntry> allowedClusterVersions = null;
    @SerializedName(value="configStalenessStatus")
    private ApiConfigStalenessStatus configStalenessStatus = null;
    @SerializedName(value="clientConfigStalenessStatus")
    private ApiConfigStalenessStatus clientConfigStalenessStatus = null;
    @SerializedName(value="healthSummary")
    private ApiHealthSummary healthSummary = null;

    public ApiDataContext name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiDataContext displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(description="")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiDataContext nameservice(String nameservice) {
        this.nameservice = nameservice;
        return this;
    }

    @Schema(description="")
    public String getNameservice() {
        return this.nameservice;
    }

    public void setNameservice(String nameservice) {
        this.nameservice = nameservice;
    }

    public ApiDataContext createdTime(String createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @Schema(description="")
    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public ApiDataContext lastModifiedTime(String lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    @Schema(description="")
    public String getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(String lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public ApiDataContext services(List<ApiServiceRef> services) {
        this.services = services;
        return this;
    }

    public ApiDataContext addServicesItem(ApiServiceRef servicesItem) {
        if (this.services == null) {
            this.services = new ArrayList<ApiServiceRef>();
        }
        this.services.add(servicesItem);
        return this;
    }

    @Schema(description="")
    public List<ApiServiceRef> getServices() {
        return this.services;
    }

    public void setServices(List<ApiServiceRef> services) {
        this.services = services;
    }

    public ApiDataContext servicesDetails(List<ApiService> servicesDetails) {
        this.servicesDetails = servicesDetails;
        return this;
    }

    public ApiDataContext addServicesDetailsItem(ApiService servicesDetailsItem) {
        if (this.servicesDetails == null) {
            this.servicesDetails = new ArrayList<ApiService>();
        }
        this.servicesDetails.add(servicesDetailsItem);
        return this;
    }

    @Schema(description="")
    public List<ApiService> getServicesDetails() {
        return this.servicesDetails;
    }

    public void setServicesDetails(List<ApiService> servicesDetails) {
        this.servicesDetails = servicesDetails;
    }

    public ApiDataContext supportedServiceTypes(List<String> supportedServiceTypes) {
        this.supportedServiceTypes = supportedServiceTypes;
        return this;
    }

    public ApiDataContext addSupportedServiceTypesItem(String supportedServiceTypesItem) {
        if (this.supportedServiceTypes == null) {
            this.supportedServiceTypes = new ArrayList<String>();
        }
        this.supportedServiceTypes.add(supportedServiceTypesItem);
        return this;
    }

    @Schema(description="")
    public List<String> getSupportedServiceTypes() {
        return this.supportedServiceTypes;
    }

    public void setSupportedServiceTypes(List<String> supportedServiceTypes) {
        this.supportedServiceTypes = supportedServiceTypes;
    }

    public ApiDataContext allowedClusterVersions(List<ApiMapEntry> allowedClusterVersions) {
        this.allowedClusterVersions = allowedClusterVersions;
        return this;
    }

    public ApiDataContext addAllowedClusterVersionsItem(ApiMapEntry allowedClusterVersionsItem) {
        if (this.allowedClusterVersions == null) {
            this.allowedClusterVersions = new ArrayList<ApiMapEntry>();
        }
        this.allowedClusterVersions.add(allowedClusterVersionsItem);
        return this;
    }

    @Schema(description="")
    public List<ApiMapEntry> getAllowedClusterVersions() {
        return this.allowedClusterVersions;
    }

    public void setAllowedClusterVersions(List<ApiMapEntry> allowedClusterVersions) {
        this.allowedClusterVersions = allowedClusterVersions;
    }

    public ApiDataContext configStalenessStatus(ApiConfigStalenessStatus configStalenessStatus) {
        this.configStalenessStatus = configStalenessStatus;
        return this;
    }

    @Schema(description="")
    public ApiConfigStalenessStatus getConfigStalenessStatus() {
        return this.configStalenessStatus;
    }

    public void setConfigStalenessStatus(ApiConfigStalenessStatus configStalenessStatus) {
        this.configStalenessStatus = configStalenessStatus;
    }

    public ApiDataContext clientConfigStalenessStatus(ApiConfigStalenessStatus clientConfigStalenessStatus) {
        this.clientConfigStalenessStatus = clientConfigStalenessStatus;
        return this;
    }

    @Schema(description="")
    public ApiConfigStalenessStatus getClientConfigStalenessStatus() {
        return this.clientConfigStalenessStatus;
    }

    public void setClientConfigStalenessStatus(ApiConfigStalenessStatus clientConfigStalenessStatus) {
        this.clientConfigStalenessStatus = clientConfigStalenessStatus;
    }

    public ApiDataContext healthSummary(ApiHealthSummary healthSummary) {
        this.healthSummary = healthSummary;
        return this;
    }

    @Schema(description="")
    public ApiHealthSummary getHealthSummary() {
        return this.healthSummary;
    }

    public void setHealthSummary(ApiHealthSummary healthSummary) {
        this.healthSummary = healthSummary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiDataContext apiDataContext = (ApiDataContext)o;
        return Objects.equals(this.name, apiDataContext.name) && Objects.equals(this.displayName, apiDataContext.displayName) && Objects.equals(this.nameservice, apiDataContext.nameservice) && Objects.equals(this.createdTime, apiDataContext.createdTime) && Objects.equals(this.lastModifiedTime, apiDataContext.lastModifiedTime) && Objects.equals(this.services, apiDataContext.services) && Objects.equals(this.servicesDetails, apiDataContext.servicesDetails) && Objects.equals(this.supportedServiceTypes, apiDataContext.supportedServiceTypes) && Objects.equals(this.allowedClusterVersions, apiDataContext.allowedClusterVersions) && Objects.equals((Object)this.configStalenessStatus, (Object)apiDataContext.configStalenessStatus) && Objects.equals((Object)this.clientConfigStalenessStatus, (Object)apiDataContext.clientConfigStalenessStatus) && Objects.equals((Object)this.healthSummary, (Object)apiDataContext.healthSummary);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.displayName, this.nameservice, this.createdTime, this.lastModifiedTime, this.services, this.servicesDetails, this.supportedServiceTypes, this.allowedClusterVersions, this.configStalenessStatus, this.clientConfigStalenessStatus, this.healthSummary});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiDataContext {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    nameservice: ").append(this.toIndentedString(this.nameservice)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    lastModifiedTime: ").append(this.toIndentedString(this.lastModifiedTime)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("    servicesDetails: ").append(this.toIndentedString(this.servicesDetails)).append("\n");
        sb.append("    supportedServiceTypes: ").append(this.toIndentedString(this.supportedServiceTypes)).append("\n");
        sb.append("    allowedClusterVersions: ").append(this.toIndentedString(this.allowedClusterVersions)).append("\n");
        sb.append("    configStalenessStatus: ").append(this.toIndentedString((Object)this.configStalenessStatus)).append("\n");
        sb.append("    clientConfigStalenessStatus: ").append(this.toIndentedString((Object)this.clientConfigStalenessStatus)).append("\n");
        sb.append("    healthSummary: ").append(this.toIndentedString((Object)this.healthSummary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

