/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.knox.gateway.shell.table.KnoxShellTable;
import org.apache.knox.gateway.shell.table.KnoxShellTableBuilder;

public class JoinKnoxShellTableBuilder
extends KnoxShellTableBuilder {
    private KnoxShellTable left;
    private KnoxShellTable right;

    JoinKnoxShellTableBuilder(KnoxShellTable table) {
        super(table);
    }

    @Override
    public JoinKnoxShellTableBuilder title(String title) {
        this.title = title;
        return this;
    }

    public JoinKnoxShellTableBuilder left(KnoxShellTable left) {
        this.left = left;
        return this;
    }

    public JoinKnoxShellTableBuilder right(KnoxShellTable right) {
        this.right = right;
        return this;
    }

    public KnoxShellTable on(String columnName) {
        int leftIndex = this.left.headers.indexOf(columnName);
        int rightIndex = this.right.headers.indexOf(columnName);
        return this.on(leftIndex, rightIndex);
    }

    public KnoxShellTable on(String columnName, String columnName2) {
        int leftIndex = this.left.headers.indexOf(columnName);
        int rightIndex = this.right.headers.indexOf(columnName2);
        return this.on(leftIndex, rightIndex);
    }

    public KnoxShellTable on(int leftIndex, int rightIndex) {
        if (this.title != null) {
            this.table.title(this.title);
        }
        this.table.headers.addAll(new ArrayList<String>(this.left.headers));
        for (List<Comparable<? extends Object>> row : this.left.rows) {
            this.table.rows.add(new ArrayList<Comparable<? extends Object>>(row));
        }
        this.table.headers.addAll(new ArrayList<String>(this.right.headers));
        Iterator<List<Comparable<? extends Object>>> it = this.table.rows.iterator();
        while (it.hasNext()) {
            List<Comparable<? extends Object>> row = it.next();
            Comparable<? extends Object> leftKey = row.get(leftIndex);
            if (leftKey == null) continue;
            int matchedIndex = this.right.values(rightIndex).indexOf(leftKey);
            if (matchedIndex > -1) {
                row.addAll((Collection<Comparable<? extends Object>>)this.right.rows.get(matchedIndex));
                continue;
            }
            it.remove();
        }
        return this.table;
    }
}

