/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.api.dao;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.catalog.api.Attribute;
import org.apache.logging.log4j.catalog.api.CatalogData;
import org.apache.logging.log4j.catalog.api.CatalogReader;
import org.apache.logging.log4j.catalog.api.Category;
import org.apache.logging.log4j.catalog.api.Event;
import org.apache.logging.log4j.catalog.api.Product;

public abstract class AbstractCatalogReader
implements CatalogReader {
    protected CatalogData catalogData = null;
    protected final Map<String, Attribute> attributes = new HashMap<String, Attribute>();

    @Override
    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public Attribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Category getCategory(String name) {
        if (this.catalogData.getCategories() != null) {
            return this.catalogData.getCategories().stream().filter(c -> c.getName().equals(name)).findFirst().orElse(null);
        }
        return null;
    }

    @Override
    public Event getEvent(String name) {
        if (this.catalogData.getEvents() != null) {
            return this.catalogData.getEvents().stream().filter(e -> e.getName().equals(name)).findFirst().orElse(null);
        }
        return null;
    }

    @Override
    public Product getProduct(String name) {
        if (this.catalogData.getProducts() != null) {
            return this.catalogData.getProducts().stream().filter(p -> p.getName().equals(name)).findFirst().orElse(null);
        }
        return null;
    }

    @Override
    public String readCatalog() {
        return null;
    }

    @Override
    public CatalogData read() {
        return this.catalogData;
    }
}

