/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.nuxeo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.nuxeo.Messages;
import org.apache.manifoldcf.crawler.connectors.nuxeo.model.NuxeoAttachment;
import org.apache.manifoldcf.crawler.connectors.nuxeo.model.NuxeoDocumentHelper;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.nuxeo.client.NuxeoClient;
import org.nuxeo.client.objects.Document;
import org.nuxeo.client.objects.Documents;
import org.nuxeo.client.spi.NuxeoClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NuxeoRepositoryConnector
extends BaseRepositoryConnector {
    private static final String URI_DOCUMENT = "SELECT * FROM Document";
    private static final String ACTIVITY_READ = "read document";
    private static final String NUXEO_SERVER_TAB_PROPERTY = "NuxeoRepositoryConnector.Server";
    private static final String CONF_DOMAINS_TAB_PROPERTY = "NuxeoRepositoryConnector.Domains";
    private static final String CONF_DOCUMENTS_TYPE_TAB_PROPERTY = "NuxeoRepositoryConnector.DocumentsType";
    private static final String CONF_DOCUMENT_PROPERTY = "NuxeoRepositoryConnector.Documents";
    private static final String PARAMETER_PREFIX = "nuxeo_";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration_conf.js";
    private static final String EDIT_CONFIG_FORWARD_SERVER = "editConfiguration_conf_server.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration_conf.html";
    private static final String EDIT_SPEC_HEADER_FORWARD = "editSpecification_conf.js";
    private static final String EDIT_SPEC_FORWARD_CONF_DOMAINS = "editSpecification_confDomains.html";
    private static final String EDIT_SPEC_FORWARD_CONF_DOCUMENTS_TYPE = "editSpecification_confDocumentsType.html";
    private static final String EDIT_SPEC_FORWARD_CONF_DOCUMENTS = "editSpecification_confDocuments.html";
    private static final String VIEW_SPEC_FORWARD = "viewSpecification_conf.html";
    protected long lastSessionFetch = -1L;
    protected static final long timeToRelease = 300000L;
    private Logger logger = LoggerFactory.getLogger(NuxeoRepositoryConnector.class);
    protected String protocol = null;
    protected String host = null;
    protected String port = null;
    protected String path = null;
    protected String username = null;
    protected String password = null;
    private NuxeoClient nuxeoClient = null;

    void setNuxeoClient(NuxeoClient nuxeoClient) {
        this.nuxeoClient = nuxeoClient;
    }

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_READ};
    }

    public String[] getBinNames(String documentIdenfitier) {
        return new String[]{this.host};
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, NUXEO_SERVER_TAB_PROPERTY));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        NuxeoRepositoryConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_HEADER_FORWARD, paramMap, true);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("TabName", tabName);
        NuxeoRepositoryConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_FORWARD_SERVER, paramMap, true);
    }

    private static void fillInServerConfigurationMap(Map<String, String> serverMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String nuxeoProtocol = parameters.getParameter("protocol");
        String nuxeoHost = parameters.getParameter("host");
        String nuxeoPort = parameters.getParameter("port");
        String nuxeoPath = parameters.getParameter("path");
        String nuxeoUsername = parameters.getParameter("username");
        String nuxeoPassword = parameters.getObfuscatedParameter("password");
        if (nuxeoProtocol == null) {
            nuxeoProtocol = "http";
        }
        if (nuxeoHost == null) {
            nuxeoHost = "";
        }
        if (nuxeoPort == null) {
            nuxeoPort = "8080";
        }
        if (nuxeoPath == null) {
            nuxeoPath = "/nuxeo";
        }
        if (nuxeoUsername == null) {
            nuxeoUsername = "";
        }
        nuxeoPassword = nuxeoPassword == null ? "" : mapper.mapPasswordToKey(nuxeoPassword);
        serverMap.put("nuxeo_protocol", nuxeoProtocol);
        serverMap.put("nuxeo_host", nuxeoHost);
        serverMap.put("nuxeo_port", nuxeoPort);
        serverMap.put("nuxeo_path", nuxeoPath);
        serverMap.put("nuxeo_username", nuxeoUsername);
        serverMap.put("nuxeo_password", nuxeoPassword);
    }

    public String processConfigurationPost(IThreadContext thredContext, IPostParameters variableContext, ConfigParams parameters) {
        String nuxeoPassword;
        String nuxeoUsername;
        String nuxeoPath;
        String nuxeoPort;
        String nuxeoHost;
        String nuxeoProtocol = variableContext.getParameter("nuxeo_protocol");
        if (nuxeoProtocol != null) {
            parameters.setParameter("protocol", nuxeoProtocol);
        }
        if ((nuxeoHost = variableContext.getParameter("nuxeo_host")) != null) {
            parameters.setParameter("host", nuxeoHost);
        }
        if ((nuxeoPort = variableContext.getParameter("nuxeo_port")) != null) {
            parameters.setParameter("port", nuxeoPort);
        }
        if ((nuxeoPath = variableContext.getParameter("nuxeo_path")) != null) {
            parameters.setParameter("path", nuxeoPath);
        }
        if ((nuxeoUsername = variableContext.getParameter("nuxeo_username")) != null) {
            parameters.setParameter("username", nuxeoUsername);
        }
        if ((nuxeoPassword = variableContext.getParameter("nuxeo_password")) != null) {
            parameters.setObfuscatedParameter("password", variableContext.mapKeyToPassword(nuxeoPassword));
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        NuxeoRepositoryConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIG_FORWARD, paramMap, true);
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.protocol = this.params.getParameter("protocol");
        this.host = this.params.getParameter("host");
        this.port = this.params.getParameter("port");
        this.path = this.params.getParameter("path");
        this.username = this.params.getParameter("username");
        this.password = this.params.getObfuscatedParameter("password");
    }

    public void disconnect() throws ManifoldCFException {
        this.shutdownNuxeoClient();
        this.protocol = null;
        this.host = null;
        this.port = null;
        this.path = null;
        this.username = null;
        this.password = null;
        super.disconnect();
    }

    public String check() throws ManifoldCFException {
        try {
            this.initNuxeoClient();
        }
        catch (NuxeoClientException ex) {
            return "Connection failed: " + ex.getMessage();
        }
        return super.check();
    }

    private void initNuxeoClient() throws ManifoldCFException {
        if (this.nuxeoClient == null) {
            if (StringUtils.isEmpty((String)this.protocol)) {
                throw new ManifoldCFException("Parameter protocol required but not set");
            }
            if (StringUtils.isEmpty((String)this.host)) {
                throw new ManifoldCFException("Parameter host required but not set");
            }
            String url = this.getUrl();
            this.nuxeoClient = new NuxeoClient.Builder().url(url).authentication(this.username, this.password).connect();
            this.nuxeoClient.schemas("*", new String[0]);
            this.nuxeoClient.header("properties", "*", new String[0]);
            this.lastSessionFetch = System.currentTimeMillis();
        }
    }

    private void shutdownNuxeoClient() {
        if (this.nuxeoClient != null) {
            this.nuxeoClient.disconnect();
            this.nuxeoClient = null;
            this.lastSessionFetch = -1L;
        }
    }

    protected String getUrl() throws ManifoldCFException {
        int portInt;
        if (this.protocol == null || this.host == null || this.path == null) {
            throw new ManifoldCFException("Nuxeo Endpoint Bad Configured");
        }
        if (this.port != null && this.port.length() > 0) {
            try {
                portInt = Integer.parseInt(this.port);
            }
            catch (NumberFormatException formatException) {
                throw new ManifoldCFException("Bad number: " + formatException.getMessage(), (Throwable)formatException);
            }
        } else {
            portInt = this.protocol.toLowerCase(Locale.ROOT).equals("http") ? 80 : 443;
        }
        String url = this.protocol + "://" + this.host + ":" + portInt + "/" + this.path;
        return url;
    }

    public boolean isConnected() {
        return this.nuxeoClient != null;
    }

    public void poll() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime > this.lastSessionFetch + 300000L) {
            this.shutdownNuxeoClient();
        }
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        this.initNuxeoClient();
        try {
            Documents docs;
            int lastStart = 0;
            int defaultSize = 50;
            Boolean isLast = true;
            NuxeoSpecification ns = NuxeoSpecification.from(spec);
            List<String> domains = ns.getDomains();
            List<String> documentsType = ns.getDocumentsType();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            Date currentDate = new Date();
            do {
                docs = this.getDocsByDate(this.nuxeoClient, lastSeedVersion, domains, documentsType, defaultSize, lastStart);
                for (Document doc : docs.getDocuments()) {
                    activities.addSeedDocument(doc.getUid());
                }
                ++lastStart;
            } while ((isLast = Boolean.valueOf(docs.isNextPageAvailable())).booleanValue());
            return sdf.format(currentDate);
        }
        catch (NuxeoClientException exception) {
            Logging.connectors.warn((Object)("NUXEO: Error adding seed documents: " + exception.getMessage()), (Throwable)exception);
            throw new ManifoldCFException("Failure during seeding: " + exception.getMessage(), (Throwable)exception);
        }
    }

    Documents getDocsByDate(NuxeoClient nuxeoClient, String date, List<String> domains, List<String> documentsType, int limit, int start) {
        String query = "";
        if (date == null || date.isEmpty()) {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", Locale.ROOT);
            date = DATE_FORMAT.format(new Date(0L));
        }
        query = "dc:modified > '" + date + "'";
        if (!domains.isEmpty()) {
            Iterator<String> itdom = domains.iterator();
            query = String.format(Locale.ROOT, " %s AND ( ecm:path STARTSWITH '/%s'", query, itdom.next());
            while (itdom.hasNext()) {
                query = String.format(Locale.ROOT, "%s OR ecm:path STARTSWITH '/%s'", query, itdom.next());
            }
            query = String.format(Locale.ROOT, "%s )", query);
        }
        if (!documentsType.isEmpty()) {
            Iterator<String> itDocTy = documentsType.iterator();
            query = String.format(Locale.ROOT, " %s AND ( ecm:primaryType = '%s'", query, itDocTy.next());
            while (itDocTy.hasNext()) {
                query = String.format(Locale.ROOT, "%s OR ecm:primaryType = '%s'", query, itDocTy.next());
            }
            query = String.format(Locale.ROOT, "%s )", query);
        }
        query = String.format(Locale.ROOT, "SELECT * FROM Document where ecm:mixinType != 'HiddenInNavigation' AND ecm:isProxy = 0 AND ecm:isCheckedInVersion = 0 AND %s ", query);
        Documents docs = nuxeoClient.repository().query(query, String.valueOf(limit), String.valueOf(start), null, null, null, null);
        return docs;
    }

    /*
     * Loose catch block
     */
    public void processDocuments(String[] documentsIdentifieres, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        this.initNuxeoClient();
        for (int i = 0; i < documentsIdentifieres.length; ++i) {
            String version;
            NuxeoDocumentHelper document;
            ProcessResult pResult;
            long startTime;
            String indexed_version;
            String documentId;
            block9: {
                documentId = documentsIdentifieres[i];
                indexed_version = statuses.getIndexedVersionString(documentId);
                startTime = System.currentTimeMillis();
                pResult = null;
                document = new NuxeoDocumentHelper(this.nuxeoClient.repository().fetchDocumentById(documentId));
                version = document.getVersion();
                if (!document.isFolder()) break block9;
                activities.noDocument(documentId, version);
                if (pResult == null || pResult.errorCode == null || pResult.errorCode.isEmpty()) continue;
                activities.recordActivity(new Long(startTime), ACTIVITY_READ, Long.valueOf(pResult.fileSize), documentId, pResult.errorCode, pResult.errorDecription, null);
                continue;
            }
            try {
                pResult = this.processDocument(document, documentId, spec, version, indexed_version, activities, Maps.newHashMap());
            }
            catch (NuxeoClientException exception) {
                this.logger.info(String.format(Locale.ROOT, "Error Fetching Nuxeo Document %s. Marking for deletion", documentId));
                activities.deleteDocument(documentId);
                if (pResult == null || pResult.errorCode == null || pResult.errorCode.isEmpty()) continue;
                activities.recordActivity(new Long(startTime), ACTIVITY_READ, Long.valueOf(pResult.fileSize), documentId, pResult.errorCode, pResult.errorDecription, null);
                continue;
            }
            catch (IOException exception2) {
                long interruptionRetryTime = 300000L;
                String message = "Server appears down during seeding: " + exception2.getMessage();
                throw new ServiceInterruption(message, (Throwable)exception2, System.currentTimeMillis() + interruptionRetryTime, -1L, 3, true);
                {
                    catch (Throwable throwable) {
                        if (pResult != null && pResult.errorCode != null && !pResult.errorCode.isEmpty()) {
                            activities.recordActivity(new Long(startTime), ACTIVITY_READ, Long.valueOf(pResult.fileSize), documentId, pResult.errorCode, pResult.errorDecription, null);
                        }
                        throw throwable;
                    }
                }
            }
            if (pResult == null || pResult.errorCode == null || pResult.errorCode.isEmpty()) continue;
            activities.recordActivity(new Long(startTime), ACTIVITY_READ, Long.valueOf(pResult.fileSize), documentId, pResult.errorCode, pResult.errorDecription, null);
            continue;
        }
    }

    private ProcessResult processDocument(NuxeoDocumentHelper doc, String manifoldDocumentIdentifier, Specification spec, String version, String indexed_version, IProcessActivity activities, HashMap<String, String> extraProperties) throws ManifoldCFException, ServiceInterruption, IOException {
        String documentUri;
        RepositoryDocument rd = new RepositoryDocument();
        NuxeoSpecification ns = NuxeoSpecification.from(spec);
        String lastModified = doc.getDocument().getLastModified();
        Date lastModifiedDate = null;
        if (lastModified != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", Locale.ROOT);
            try {
                lastModifiedDate = formatter.parse(lastModified);
            }
            catch (Exception ex) {
                lastModifiedDate = new Date(0L);
            }
        }
        int length = doc.getLength();
        if (doc.getDocument().getState() != null && doc.getDocument().getState().equalsIgnoreCase("deleted")) {
            activities.deleteDocument(manifoldDocumentIdentifier);
            return new ProcessResult(length, "DELETED", "");
        }
        if (!activities.checkDocumentNeedsReindexing(manifoldDocumentIdentifier, lastModified)) {
            return new ProcessResult(length, "RETAINED", "");
        }
        if (doc.getDocument().getUid() == null) {
            activities.deleteDocument(manifoldDocumentIdentifier);
            return new ProcessResult(length, "DELETED", "");
        }
        if (!activities.checkLengthIndexable((long)length)) {
            activities.noDocument(manifoldDocumentIdentifier, version);
            return new ProcessResult(length, "EXCLUDEDLENGTH", "Document excluded because of length (" + length + ")");
        }
        String url = this.getUrl();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (!activities.checkURLIndexable(documentUri = url + "/nxpath/" + doc.getDocument().getRepositoryName() + doc.getDocument().getPath() + "@view_documents")) {
            activities.noDocument(manifoldDocumentIdentifier, version);
            return new ProcessResult(length, "EXCLUDEDURL", "Document excluded because of URL ('" + documentUri + "')");
        }
        if (!activities.checkDateIndexable(lastModifiedDate)) {
            activities.noDocument(manifoldDocumentIdentifier, version);
            return new ProcessResult(length, "EXCLUDEDDATE", "Document excluded because of date (" + lastModifiedDate + ")");
        }
        if (!activities.checkMimeTypeIndexable(doc.getMimeType())) {
            activities.noDocument(manifoldDocumentIdentifier, version);
            return new ProcessResult(length, "EXCLUDEDMIMETYPE", "Document excluded because of mime type ('" + doc.getMimeType() + "')");
        }
        rd.setMimeType(doc.getMimeType());
        rd.setModifiedDate(lastModifiedDate);
        rd.setFileName(doc.getFilename());
        rd.setIndexingDate(new Date());
        rd.setBinary(doc.getContent(), (long)length);
        Map<String, Object> docMetadata = doc.getMetadata();
        for (Map.Entry<String, Object> entry : docMetadata.entrySet()) {
            if (entry.getValue() instanceof List) {
                List list = (List)entry.getValue();
                try {
                    rd.addField(entry.getKey(), list.toArray(new String[list.size()]));
                }
                catch (ArrayStoreException e) {}
                continue;
            }
            rd.addField(entry.getKey(), entry.getValue().toString());
        }
        if (ns.isProcessTags().booleanValue()) {
            rd.addField("Tags", doc.getTags(this.nuxeoClient));
        }
        String[] permissions = doc.getPermissions();
        rd.setSecurityACL("document", permissions);
        rd.setSecurityDenyACL("document", new String[]{"DEAD_AUTHORITY"});
        activities.ingestDocumentWithException(manifoldDocumentIdentifier, version, documentUri, rd);
        if (ns.isProcessAttachments().booleanValue()) {
            for (NuxeoAttachment att : doc.getAttachments(this.nuxeoClient)) {
                RepositoryDocument att_rd = new RepositoryDocument();
                String attDocumentUri = att.getUrl();
                att_rd.setMimeType(att.getMime_type());
                att_rd.setBinary(att.getData(), att.getLength());
                if (lastModified != null) {
                    att_rd.setModifiedDate(lastModifiedDate);
                }
                att_rd.setIndexingDate(new Date());
                att_rd.addField("name", att.getName());
                att_rd.addField("length", String.valueOf(att.getLength()));
                att_rd.addField("digest", att.getDigest());
                att_rd.addField("digestAlgorithm", att.getDigestAlgorithm());
                att_rd.addField("encoding", att.getEncoding());
                att_rd.setSecurityACL("document", permissions);
                att_rd.setSecurityDenyACL("document", new String[]{"DEAD_AUTHORITY"});
                activities.ingestDocumentWithException(manifoldDocumentIdentifier, attDocumentUri, lastModified, attDocumentUri, att_rd);
            }
        }
        return new ProcessResult(length, "OK", "");
    }

    public int getConnectorModel() {
        return 3;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification spec, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        NuxeoSpecification ns = NuxeoSpecification.from(spec);
        paramMap.put("domains".toUpperCase(Locale.ROOT), ns.getDomains());
        paramMap.put("documentsType".toUpperCase(Locale.ROOT), ns.documentsType);
        paramMap.put("process_tags".toUpperCase(Locale.ROOT), ns.isProcessTags().toString());
        paramMap.put("process_attachments".toUpperCase(Locale.ROOT), ns.isProcessAttachments().toString());
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPEC_FORWARD, paramMap);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String xt;
        SpecificationNode node;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String xc = variableContext.getParameter(seqPrefix + "domainscount");
        if (xc != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn = ds.getChild(i);
                if (sn.getType().equals("domains")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode domains = new SpecificationNode("domains");
            ds.addChild(ds.getChildCount(), (ConfigurationNode)domains);
            int domainsCount = Integer.parseInt(xc);
            i = 0;
            while (i < domainsCount) {
                String domainDescription = "_" + Integer.toString(i);
                String domainOpName = seqPrefix + "domainop" + domainDescription;
                xc = variableContext.getParameter(domainOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String domainKey = variableContext.getParameter(seqPrefix + "domain" + domainDescription);
                node = new SpecificationNode("domain");
                node.setAttribute("key", domainKey);
                domains.addChild(domains.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            String op = variableContext.getParameter(seqPrefix + "domainop");
            if (op != null && op.equals("Add")) {
                String domainSpec = variableContext.getParameter(seqPrefix + "domain");
                SpecificationNode node2 = new SpecificationNode("domain");
                node2.setAttribute("key", domainSpec);
                domains.addChild(domains.getChildCount(), (ConfigurationNode)node2);
            }
        }
        if ((xt = variableContext.getParameter(seqPrefix + "documentsTypecount")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn = ds.getChild(i);
                if (sn.getType().equals("documentsType")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode documentsType = new SpecificationNode("documentsType");
            ds.addChild(ds.getChildCount(), (ConfigurationNode)documentsType);
            int documentsTypeCount = Integer.parseInt(xt);
            i = 0;
            while (i < documentsTypeCount) {
                String documentTypeDescription = "_" + Integer.toString(i);
                String documentTypeOpName = seqPrefix + "documentTypeop" + documentTypeDescription;
                xt = variableContext.getParameter(documentTypeOpName);
                if (xt != null && xt.equals("Delete")) {
                    ++i;
                    continue;
                }
                String documentTypeKey = variableContext.getParameter(seqPrefix + "documentType" + documentTypeDescription);
                SpecificationNode node3 = new SpecificationNode("documentType");
                node3.setAttribute("key", documentTypeKey);
                documentsType.addChild(documentsType.getChildCount(), (ConfigurationNode)node3);
                ++i;
            }
            String op = variableContext.getParameter(seqPrefix + "documentTypeop");
            if (op != null && op.equals("Add")) {
                String documentTypeSpec = variableContext.getParameter(seqPrefix + "documentType");
                node = new SpecificationNode("documentType");
                node.setAttribute("key", documentTypeSpec);
                documentsType.addChild(documentsType.getChildCount(), (ConfigurationNode)node);
            }
        }
        SpecificationNode documents = new SpecificationNode("documents");
        ds.addChild(ds.getChildCount(), (ConfigurationNode)documents);
        String processTags = variableContext.getParameter(seqPrefix + "process_tags");
        String processAttachments = variableContext.getParameter(seqPrefix + "process_attachments");
        if (processTags != null && !processTags.isEmpty()) {
            documents.setAttribute("process_tags", String.valueOf(processTags));
        }
        if (processAttachments != null && !processAttachments.isEmpty()) {
            documents.setAttribute("process_attachments", String.valueOf(processAttachments));
        }
        return null;
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification spec, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        paramMap.put("SelectedNum", Integer.toString(actualSequenceNumber));
        NuxeoSpecification ns = NuxeoSpecification.from(spec);
        paramMap.put("domains".toUpperCase(Locale.ROOT), ns.getDomains());
        paramMap.put("documentsType".toUpperCase(Locale.ROOT), ns.getDocumentsType());
        paramMap.put("process_tags".toUpperCase(Locale.ROOT), ns.isProcessTags());
        paramMap.put("process_attachments".toUpperCase(Locale.ROOT), ns.isProcessAttachments());
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_FORWARD_CONF_DOMAINS, paramMap);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_FORWARD_CONF_DOCUMENTS_TYPE, paramMap);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_FORWARD_CONF_DOCUMENTS, paramMap);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification spec, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, CONF_DOMAINS_TAB_PROPERTY));
        tabsArray.add(Messages.getString(locale, CONF_DOCUMENTS_TYPE_TAB_PROPERTY));
        tabsArray.add(Messages.getString(locale, CONF_DOCUMENT_PROPERTY));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_HEADER_FORWARD, paramMap);
    }

    static class NuxeoSpecification {
        private List<String> domains;
        private List<String> documentsType;
        private Boolean processTags = false;
        private Boolean processAttahcments = false;

        NuxeoSpecification() {
        }

        public List<String> getDomains() {
            return this.domains;
        }

        public List<String> getDocumentsType() {
            return this.documentsType;
        }

        public Boolean isProcessTags() {
            return this.processTags;
        }

        public Boolean isProcessAttachments() {
            return this.processAttahcments;
        }

        public static NuxeoSpecification from(Specification spec) {
            NuxeoSpecification ns = new NuxeoSpecification();
            ns.domains = Lists.newArrayList();
            ns.documentsType = Lists.newArrayList();
            int len = spec.getChildCount();
            for (int i = 0; i < len; ++i) {
                SpecificationNode spectNode;
                SpecificationNode sn = spec.getChild(i);
                if (sn.getType().equals("domains")) {
                    int sLen = sn.getChildCount();
                    for (int j = 0; j < sLen; ++j) {
                        spectNode = sn.getChild(j);
                        if (!spectNode.getType().equals("domain")) continue;
                        ns.domains.add(spectNode.getAttributeValue("key"));
                    }
                    continue;
                }
                if (sn.getType().equals("documentsType")) {
                    int sLen = sn.getChildCount();
                    for (int j = 0; j < sLen; ++j) {
                        spectNode = sn.getChild(j);
                        if (!spectNode.getType().equals("documentType")) continue;
                        ns.documentsType.add(spectNode.getAttributeValue("key"));
                    }
                    continue;
                }
                if (!sn.getType().equals("documents")) continue;
                String procTags = sn.getAttributeValue("process_tags");
                ns.processTags = Boolean.valueOf(procTags);
                String procAtt = sn.getAttributeValue("process_attachments");
                ns.processAttahcments = Boolean.valueOf(procAtt);
            }
            return ns;
        }
    }

    private class ProcessResult {
        private long fileSize;
        private String errorCode;
        private String errorDecription;

        private ProcessResult(long fileSize, String errorCode, String errorDescription) {
            this.fileSize = fileSize;
            this.errorCode = errorCode;
            this.errorDecription = errorDescription;
        }
    }
}

