/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.filter.ArithmeticFunction;
import org.apache.sis.filter.BinarySpatialFilter;
import org.apache.sis.filter.ComparisonFilter;
import org.apache.sis.filter.DistanceFilter;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.IdentifierFilter;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.LikeFilter;
import org.apache.sis.filter.LogicalFilter;
import org.apache.sis.filter.PropertyValue;
import org.apache.sis.filter.TemporalFilter;
import org.apache.sis.filter.UnaryFunction;
import org.apache.sis.geometry.WraparoundMethod;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.filter.FunctionRegister;
import org.apache.sis.internal.filter.sqlmm.Registry;
import org.apache.sis.internal.geoapi.filter.DistanceOperatorName;
import org.apache.sis.internal.geoapi.filter.MatchAction;
import org.apache.sis.internal.geoapi.filter.SpatialOperatorName;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;

public abstract class DefaultFilterFactory<R, G, T>
extends AbstractFactory {
    private final Geometries<G> library;
    private final WraparoundMethod wraparound;
    private final Map<String, FunctionRegister> availableFunctions;

    protected DefaultFilterFactory(Class<G> clazz, Class<T> clazz2, WraparoundMethod wraparoundMethod) {
        ArgumentChecks.ensureNonNull("spatial", clazz);
        ArgumentChecks.ensureNonNull("temporal", clazz2);
        ArgumentChecks.ensureNonNull("wraparound", wraparoundMethod);
        if (clazz == Object.class) {
            this.library = Geometries.implementation((GeometryLibrary)null);
        } else {
            this.library = Geometries.implementation(clazz);
            if (this.library == null || this.library.rootClass != clazz) {
                throw new IllegalArgumentException(Errors.format((short)45, "spatial", clazz));
            }
        }
        if (clazz2 != Object.class) {
            throw new IllegalArgumentException(Errors.format((short)45, "temporal", clazz2));
        }
        this.wraparound = wraparoundMethod;
        this.availableFunctions = new HashMap<String, FunctionRegister>();
    }

    public static synchronized DefaultFilterFactory<AbstractFeature, Object, Object> forFeatures() {
        return Features.DEFAULT;
    }

    public abstract Filter<R> resourceId(String var1);

    public Expression<R, ?> property(String string) {
        return this.property(string, Object.class);
    }

    public abstract <V> Expression<R, V> property(String var1, Class<V> var2);

    public <V> Expression<R, V> literal(V v) {
        return new LeafExpression.Literal(v);
    }

    public Filter<R> equal(Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        return new ComparisonFilter.EqualTo<R>(expression, expression2, true, MatchAction.ANY);
    }

    public Filter<R> notEqual(Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        return new ComparisonFilter.NotEqualTo<R>(expression, expression2, true, MatchAction.ANY);
    }

    public Filter<R> less(Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        return new ComparisonFilter.LessThan<R>(expression, expression2, true, MatchAction.ANY);
    }

    public Filter<R> greater(Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        return new ComparisonFilter.GreaterThan<R>(expression, expression2, true, MatchAction.ANY);
    }

    public Filter<R> lessOrEqual(Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        return new ComparisonFilter.LessThanOrEqualTo<R>(expression, expression2, true, MatchAction.ANY);
    }

    public Filter<R> greaterOrEqual(Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        return new ComparisonFilter.GreaterThanOrEqualTo<R>(expression, expression2, true, MatchAction.ANY);
    }

    public Filter<R> between(Expression<? super R, ?> expression, Expression<? super R, ?> expression2, Expression<? super R, ?> expression3) {
        return new ComparisonFilter.Between<R>(expression, expression2, expression3);
    }

    public Filter<R> like(Expression<? super R, ?> expression, String string) {
        return this.like(expression, string, '%', '_', '\\', true);
    }

    public Filter<R> like(Expression<? super R, ?> expression, String string, char c, char c2, char c3, boolean bl) {
        return new LikeFilter<R>(expression, string, c, c2, c3, bl);
    }

    public Filter<R> isNull(Expression<? super R, ?> expression) {
        return new UnaryFunction.IsNull<R>(expression);
    }

    public Filter<R> isNil(Expression<? super R, ?> expression, String string) {
        return new UnaryFunction.IsNil<R>(expression, string);
    }

    public Filter<R> and(Filter<? super R> filter, Filter<? super R> filter2) {
        ArgumentChecks.ensureNonNull("operand1", filter);
        ArgumentChecks.ensureNonNull("operand2", filter2);
        return new LogicalFilter.And<R>(filter, filter2);
    }

    public Filter<R> and(Collection<? extends Filter<? super R>> collection) {
        return new LogicalFilter.And(collection);
    }

    public Filter<R> or(Filter<? super R> filter, Filter<? super R> filter2) {
        ArgumentChecks.ensureNonNull("operand1", filter);
        ArgumentChecks.ensureNonNull("operand2", filter2);
        return new LogicalFilter.Or<R>(filter, filter2);
    }

    public Filter<R> or(Collection<? extends Filter<? super R>> collection) {
        return new LogicalFilter.Or(collection);
    }

    public Filter<R> not(Filter<? super R> filter) {
        return new LogicalFilter.Not<R>(filter);
    }

    public Filter<R> bbox(Expression<? super R, ? extends G> expression, Envelope envelope) {
        return new BinarySpatialFilter<R, G>(this.library, expression, envelope, this.wraparound);
    }

    public Filter<R> equals(Expression<? super R, ? extends G> expression, Expression<? super R, ? extends G> expression2) {
        return new BinarySpatialFilter<R, G>(SpatialOperatorName.EQUALS, this.library, expression, expression2);
    }

    public Filter<R> disjoint(Expression<? super R, ? extends G> expression, Expression<? super R, ? extends G> expression2) {
        return new BinarySpatialFilter<R, G>(SpatialOperatorName.DISJOINT, this.library, expression, expression2);
    }

    public Filter<R> intersects(Expression<? super R, ? extends G> expression, Expression<? super R, ? extends G> expression2) {
        return new BinarySpatialFilter<R, G>(SpatialOperatorName.INTERSECTS, this.library, expression, expression2);
    }

    public Filter<R> touches(Expression<? super R, ? extends G> expression, Expression<? super R, ? extends G> expression2) {
        return new BinarySpatialFilter<R, G>(SpatialOperatorName.TOUCHES, this.library, expression, expression2);
    }

    public Filter<R> crosses(Expression<? super R, ? extends G> expression, Expression<? super R, ? extends G> expression2) {
        return new BinarySpatialFilter<R, G>(SpatialOperatorName.CROSSES, this.library, expression, expression2);
    }

    public Filter<R> within(Expression<? super R, ? extends G> expression, Expression<? super R, ? extends G> expression2) {
        return new BinarySpatialFilter<R, G>(SpatialOperatorName.WITHIN, this.library, expression, expression2);
    }

    public Filter<R> contains(Expression<? super R, ? extends G> expression, Expression<? super R, ? extends G> expression2) {
        return new BinarySpatialFilter<R, G>(SpatialOperatorName.CONTAINS, this.library, expression, expression2);
    }

    public Filter<R> overlaps(Expression<? super R, ? extends G> expression, Expression<? super R, ? extends G> expression2) {
        return new BinarySpatialFilter<R, G>(SpatialOperatorName.OVERLAPS, this.library, expression, expression2);
    }

    public Filter<R> beyond(Expression<? super R, ? extends G> expression, Expression<? super R, ? extends G> expression2, Quantity<Length> quantity) {
        return new DistanceFilter<R, G>(DistanceOperatorName.BEYOND, this.library, expression, expression2, quantity);
    }

    public Filter<R> within(Expression<? super R, ? extends G> expression, Expression<? super R, ? extends G> expression2, Quantity<Length> quantity) {
        return new DistanceFilter<R, G>(DistanceOperatorName.WITHIN, this.library, expression, expression2, quantity);
    }

    public Filter<R> after(Expression<? super R, ? extends T> expression, Expression<? super R, ? extends T> expression2) {
        return new TemporalFilter.After<R>(expression, expression2);
    }

    public Filter<R> before(Expression<? super R, ? extends T> expression, Expression<? super R, ? extends T> expression2) {
        return new TemporalFilter.Before<R>(expression, expression2);
    }

    public Filter<R> begins(Expression<? super R, ? extends T> expression, Expression<? super R, ? extends T> expression2) {
        return new TemporalFilter.Begins<R>(expression, expression2);
    }

    public Filter<R> begunBy(Expression<? super R, ? extends T> expression, Expression<? super R, ? extends T> expression2) {
        return new TemporalFilter.BegunBy<R>(expression, expression2);
    }

    public Filter<R> tcontains(Expression<? super R, ? extends T> expression, Expression<? super R, ? extends T> expression2) {
        return new TemporalFilter.Contains<R>(expression, expression2);
    }

    public Filter<R> during(Expression<? super R, ? extends T> expression, Expression<? super R, ? extends T> expression2) {
        return new TemporalFilter.During<R>(expression, expression2);
    }

    public Filter<R> tequals(Expression<? super R, ? extends T> expression, Expression<? super R, ? extends T> expression2) {
        return new TemporalFilter.Equals<R>(expression, expression2);
    }

    public Filter<R> toverlaps(Expression<? super R, ? extends T> expression, Expression<? super R, ? extends T> expression2) {
        return new TemporalFilter.Overlaps<R>(expression, expression2);
    }

    public Filter<R> meets(Expression<? super R, ? extends T> expression, Expression<? super R, ? extends T> expression2) {
        return new TemporalFilter.Meets<R>(expression, expression2);
    }

    public Filter<R> ends(Expression<? super R, ? extends T> expression, Expression<? super R, ? extends T> expression2) {
        return new TemporalFilter.Ends<R>(expression, expression2);
    }

    public Filter<R> overlappedBy(Expression<? super R, ? extends T> expression, Expression<? super R, ? extends T> expression2) {
        return new TemporalFilter.OverlappedBy<R>(expression, expression2);
    }

    public Filter<R> metBy(Expression<? super R, ? extends T> expression, Expression<? super R, ? extends T> expression2) {
        return new TemporalFilter.MetBy<R>(expression, expression2);
    }

    public Filter<R> endedBy(Expression<? super R, ? extends T> expression, Expression<? super R, ? extends T> expression2) {
        return new TemporalFilter.EndedBy<R>(expression, expression2);
    }

    public Filter<R> anyInteracts(Expression<? super R, ? extends T> expression, Expression<? super R, ? extends T> expression2) {
        return new TemporalFilter.AnyInteracts<R>(expression, expression2);
    }

    public Expression<R, Number> add(Expression<? super R, ? extends Number> expression, Expression<? super R, ? extends Number> expression2) {
        return new ArithmeticFunction.Add<R>(expression, expression2);
    }

    public Expression<R, Number> subtract(Expression<? super R, ? extends Number> expression, Expression<? super R, ? extends Number> expression2) {
        return new ArithmeticFunction.Subtract<R>(expression, expression2);
    }

    public Expression<R, Number> multiply(Expression<? super R, ? extends Number> expression, Expression<? super R, ? extends Number> expression2) {
        return new ArithmeticFunction.Multiply<R>(expression, expression2);
    }

    public Expression<R, Number> divide(Expression<? super R, ? extends Number> expression, Expression<? super R, ? extends Number> expression2) {
        return new ArithmeticFunction.Divide<R>(expression, expression2);
    }

    public Expression<R, ?> function(String string, Expression<? super R, ?> expression) {
        return this.function(string, new Expression[]{expression});
    }

    public Expression<R, ?> function(String string, Expression<? super R, ?> expression, Expression<? super R, ?> expression2) {
        return this.function(string, new Expression[]{expression, expression2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression<R, ?> function(String string, Expression<? super R, ?>[] expressionArray) {
        FunctionRegister functionRegister;
        ArgumentChecks.ensureNonNull("name", string);
        ArgumentChecks.ensureNonNull("parameters", expressionArray);
        expressionArray = (Expression[])expressionArray.clone();
        for (int i = 0; i < expressionArray.length; ++i) {
            ArgumentChecks.ensureNonNullElement("parameters", i, expressionArray[i]);
        }
        Map<String, FunctionRegister> map = this.availableFunctions;
        synchronized (map) {
            if (this.availableFunctions.isEmpty()) {
                Registry registry = new Registry(this.library);
                for (String object : registry.getNames()) {
                    this.availableFunctions.put(object, registry);
                }
                for (FunctionRegister functionRegister2 : ServiceLoader.load(FunctionRegister.class)) {
                    for (String string2 : functionRegister2.getNames()) {
                        this.availableFunctions.putIfAbsent(string2, functionRegister2);
                    }
                }
            }
            functionRegister = this.availableFunctions.get(string);
        }
        if (functionRegister == null) {
            throw new IllegalArgumentException(Resources.format((short)70, string));
        }
        return functionRegister.create(string, expressionArray);
    }

    public static class Features<G, T>
    extends DefaultFilterFactory<AbstractFeature, G, T> {
        static final DefaultFilterFactory<AbstractFeature, Object, Object> DEFAULT = new Features<Object, Object>(Object.class, Object.class, WraparoundMethod.SPLIT);

        public Features(Class<G> clazz, Class<T> clazz2, WraparoundMethod wraparoundMethod) {
            super(clazz, clazz2, wraparoundMethod);
        }

        @Override
        public Filter<AbstractFeature> resourceId(String string) {
            return new IdentifierFilter<AbstractFeature>(string);
        }

        @Override
        public <V> Expression<AbstractFeature, V> property(String string, Class<V> clazz) {
            return PropertyValue.create(string, clazz);
        }
    }
}

