/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.error.Error;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.map.BitMap;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class BitMapCachedObject
extends CachedObjectBase {
    public static final int fileSizeFactor = 4;
    BitMap bitMap;

    public BitMapCachedObject(int n) {
        this.bitMap = new BitMap(new int[n]);
        this.hasChanged = true;
    }

    public CachedObject newInstance(int n) {
        return new BitMapCachedObject(n);
    }

    @Override
    public void read(RowInputInterface rowInputInterface) {
        this.position = rowInputInterface.getPos();
        int[] nArray = this.bitMap.getIntArray();
        int n = nArray.length;
        try {
            for (int i = 0; i < n; ++i) {
                nArray[i] = rowInputInterface.readInt();
            }
        }
        catch (IOException iOException) {
            throw Error.error(467, iOException);
        }
        this.hasChanged = false;
    }

    @Override
    public int getDefaultCapacity() {
        return this.bitMap.getIntArray().length;
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return this.bitMap.getIntArray().length * 4;
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        int[] nArray = this.bitMap.getIntArray();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            rowOutputInterface.writeInt(nArray[i]);
        }
        rowOutputInterface.writeEnd();
        this.hasChanged = false;
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, LongLookup longLookup) {
        this.write(rowOutputInterface);
    }

    public BitMap getBitMap() {
        return this.bitMap;
    }
}

