/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.newgeneric;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.newgeneric.Messages;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ICacheCreateHandle;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class NewGenericAuthority
extends BaseAuthorityConnector {
    private static final String globalDenyToken = "DEAD_AUTHORITY";
    private static final AuthorizationResponse unreachableResponse = new AuthorizationResponse(new String[]{"DEAD_AUTHORITY"}, 1);
    private HttpClientConnectionManager connectionManager = null;
    private HttpClientBuilder builder = null;
    private CloseableHttpClient httpClient = null;
    private int connectionTimeout = -1;
    private int socketTimeout = -1;
    private long sessionTimeout = -1L;
    protected static final long sessionExpirationInterval = 300000L;
    private String newgenericLogin = null;
    private String newgenericPassword = null;
    private String newgenericEntryPoint = null;
    private String connectionTimeoutString = null;
    private String socketTimeoutString = null;
    private String responseLifeTimeString = null;
    private final int LRUsize = 1000;
    private final long responseLifetime = 60000L;
    private static final String EDIT_CONFIGURATION_AUTHORITY_JS = "editConfiguration.js";
    private static final String EDIT_CONFIGURATION_AUTHORITY_HTML = "editConfiguration_Server.html";
    private static final String VIEW_CONFIGURATION_AUTHORITY_HTML = "viewConfiguration.html";
    private ICacheManager cacheManager = null;
    protected static StringSet emptyStringSet = new StringSet();

    protected void getSession() throws ManifoldCFException {
        if (this.sessionTimeout == -1L) {
            try {
                this.connectionTimeout = Integer.parseInt(this.connectionTimeoutString);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad connection timeout number: " + this.connectionTimeoutString);
            }
            try {
                this.socketTimeout = Integer.parseInt(this.socketTimeoutString);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad socket timeout number: " + this.socketTimeoutString);
            }
            TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
            SSLConnectionSocketFactory sslsf = SSLConnectionSocketFactory.getSocketFactory();
            try {
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
                sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new ManifoldCFException("SSL context initialization failure", (Throwable)e);
            }
            PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build());
            poolingConnectionManager.setDefaultMaxPerRoute(1);
            poolingConnectionManager.setValidateAfterInactivity(2000);
            poolingConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(this.socketTimeout).build());
            this.connectionManager = poolingConnectionManager;
            RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(this.socketTimeout).setExpectContinueEnabled(false).setConnectTimeout(this.connectionTimeout).setConnectionRequestTimeout(this.socketTimeout);
            String auth = this.newgenericLogin + ":" + this.newgenericPassword;
            String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.ISO_8859_1));
            String authHeader = "Basic " + new String(encodedAuth);
            BasicHeader basicAuthheader = new BasicHeader("Authorization", authHeader);
            ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
            headers.add(basicAuthheader);
            this.builder = HttpClients.custom().setDefaultHeaders(headers).setConnectionManager(this.connectionManager).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build());
            this.builder.setRequestExecutor(new HttpRequestExecutor(this.socketTimeout)).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
            this.httpClient = this.builder.build();
        }
        this.sessionTimeout = System.currentTimeMillis() + 300000L;
    }

    public void setThreadContext(IThreadContext tc) throws ManifoldCFException {
        super.setThreadContext(tc);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)tc);
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.newgenericEntryPoint = configParams.getParameter("newGenericAddress");
        this.connectionTimeoutString = configParams.getParameter("connectionTimeout");
        this.socketTimeoutString = configParams.getParameter("socketTimeout");
        this.newgenericLogin = configParams.getParameter("login");
        this.newgenericPassword = configParams.getParameter("password");
        this.responseLifeTimeString = configParams.getParameter("responselifetime");
        if (this.newgenericLogin == null) {
            this.newgenericLogin = "";
        }
        if (this.newgenericPassword == null) {
            this.newgenericPassword = "";
        }
        if (this.connectionTimeoutString == null) {
            this.connectionTimeoutString = "60000";
        }
        if (this.socketTimeoutString == null) {
            this.socketTimeoutString = "180000";
        }
        if (this.responseLifeTimeString == null) {
            this.responseLifeTimeString = "120000";
        }
    }

    protected void expireSession() {
        this.httpClient = null;
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
        this.connectionManager = null;
        this.sessionTimeout = -1L;
    }

    public void poll() {
        if (System.currentTimeMillis() >= this.sessionTimeout) {
            this.expireSession();
        }
        if (this.connectionManager != null) {
            this.connectionManager.closeIdleConnections(60000L, TimeUnit.MILLISECONDS);
        }
    }

    public boolean isConnected() {
        return this.sessionTimeout != -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String check() throws ManifoldCFException {
        this.getSession();
        CloseableHttpResponse response = null;
        try {
            try {
                Logging.authorityConnectors.debug((Object)("Testing API request: " + this.newgenericEntryPoint));
                HttpGet httpGet = new HttpGet(this.newgenericEntryPoint);
                response = this.httpClient.execute((HttpUriRequest)httpGet);
            }
            catch (IOException e) {
                Logging.authorityConnectors.debug((Object)("Request failure: " + e.getMessage()));
                String string = "Connection error: " + e.getMessage();
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException e2) {
                        return "Connection error: " + e2.getMessage();
                    }
                }
                return string;
            }
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                Logging.authorityConnectors.debug((Object)("Request KO: " + responseCode + " " + response.getStatusLine().getReasonPhrase()));
                String string = "Bad response: " + String.valueOf(response.getStatusLine());
                return string;
            }
            Logging.authorityConnectors.debug((Object)"Request OK");
            String string = super.check();
            return string;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    return "Connection error: " + e.getMessage();
                }
            }
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.newgenericEntryPoint = null;
        this.newgenericLogin = null;
        this.newgenericPassword = null;
        super.disconnect();
    }

    protected String createCacheConnectionString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.newgenericEntryPoint).append("#").append(this.newgenericLogin);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        this.getSession();
        GenericAuthorizationResponseDescription objectDescription = new GenericAuthorizationResponseDescription(userName, this.createCacheConnectionString(), this.responseLifetime, this.LRUsize);
        ICacheHandle ch = this.cacheManager.enterCache(new ICacheDescription[]{objectDescription}, null, null);
        try {
            AuthorizationResponse response;
            ICacheCreateHandle createHandle;
            block9: {
                AuthorizationResponse authorizationResponse;
                createHandle = this.cacheManager.enterCreateSection(ch);
                try {
                    response = (AuthorizationResponse)this.cacheManager.lookupObject(createHandle, (ICacheDescription)objectDescription);
                    if (response == null) break block9;
                    if (Logging.authorityConnectors != null) {
                        Logging.authorityConnectors.debug((Object)("New generic: response in the cache status: " + response.getResponseStatus()));
                    }
                    authorizationResponse = response;
                }
                catch (Throwable throwable) {
                    this.cacheManager.leaveCreateSection(createHandle);
                    throw throwable;
                }
                this.cacheManager.leaveCreateSection(createHandle);
                return authorizationResponse;
            }
            response = this.getAuthorizationResponseUncached(userName);
            this.cacheManager.saveObject(createHandle, (ICacheDescription)objectDescription, (Object)response);
            AuthorizationResponse authorizationResponse = response;
            this.cacheManager.leaveCreateSection(createHandle);
            return authorizationResponse;
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    protected AuthorizationResponse getAuthorizationResponseUncached(String userName) throws ManifoldCFException {
        StringBuilder url = new StringBuilder(this.newgenericEntryPoint);
        url.append("?username=").append(userName);
        if (Logging.authorityConnectors != null) {
            Logging.authorityConnectors.debug((Object)("New generic: url: " + String.valueOf(url)));
        }
        List<Object> permissions = new ArrayList();
        permissions = this.getNewGenericUserSecurity(userName);
        if (permissions == null || permissions.isEmpty()) {
            Logging.authorityConnectors.debug((Object)("No security found for user '" + userName + "'"));
            return RESPONSE_USERNOTFOUND_ADDITIVE;
        }
        Logging.authorityConnectors.debug((Object)("Found security groups for user '" + userName + "'"));
        String[] tokens = new String[permissions.size()];
        for (int k = 0; k < tokens.length; ++k) {
            tokens[k] = (String)permissions.get(k);
            Logging.authorityConnectors.debug((Object)("security group " + k + " for user '" + userName + " " + (String)permissions.get(k) + "'"));
        }
        return new AuthorizationResponse(tokens, 0);
    }

    protected List<String> getNewGenericUserSecurity(String username) throws ManifoldCFException {
        ArrayList<String> permissions;
        block19: {
            this.getSession();
            Logging.authorityConnectors.debug((Object)("test username " + username));
            permissions = new ArrayList<String>();
            try {
                Logging.authorityConnectors.debug((Object)("Send search user request to API: " + this.newgenericEntryPoint + "?username=" + username));
                HttpGet getSecurity = new HttpGet(this.newgenericEntryPoint + "?username=" + username);
                try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)getSecurity);){
                    if (response.getStatusLine().getStatusCode() != 200) break block19;
                    try (InputStream isResp = response.getEntity().getContent();){
                        JSONParser parser = new JSONParser();
                        Object obj = parser.parse((Reader)new InputStreamReader(isResp));
                        JSONObject jsonObject = (JSONObject)obj;
                        JSONArray security = (JSONArray)jsonObject.get((Object)"tokens");
                        for (int i = 0; i < security.size(); ++i) {
                            String groupUser = (String)security.get(i);
                            if (!groupUser.equals("authenticated")) {
                                permissions.add(groupUser);
                            }
                            if (Logging.authorityConnectors == null) continue;
                            Logging.authorityConnectors.debug((Object)("New generic: permission : " + groupUser));
                        }
                    }
                    catch (ParseException e) {
                        throw new ManifoldCFException("Could not reach new generic API: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                throw new ManifoldCFException("Could not reach new generic API: " + e.getMessage(), (Throwable)e);
            }
        }
        if (permissions.size() == 0) {
            permissions = null;
        }
        return permissions;
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return unreachableResponse;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "NewGeneric.NewGenericTabName"));
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_AUTHORITY_JS, null);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("TabName", tabName);
        NewGenericAuthority.fillInServerTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_AUTHORITY_HTML, velocityContext);
    }

    protected static void fillInServerTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) throws ManifoldCFException {
        String responselifetime;
        String password;
        String login;
        String socketTimeout;
        String connectionTimeout;
        String newgenericAddress = parameters.getParameter("newGenericAddress");
        if (newgenericAddress == null) {
            newgenericAddress = "http://your.json.service.com";
        }
        if ((connectionTimeout = parameters.getParameter("connectionTimeout")) == null) {
            connectionTimeout = "60000";
        }
        if ((socketTimeout = parameters.getParameter("socketTimeout")) == null) {
            socketTimeout = "180000";
        }
        if ((login = parameters.getParameter("login")) == null) {
            login = "";
        }
        if ((password = parameters.getParameter("password")) == null) {
            password = "";
        }
        if ((responselifetime = parameters.getParameter("responselifetime")) == null) {
            responselifetime = "120000";
        }
        velocityContext.put("ADDRESS", newgenericAddress);
        velocityContext.put("CONNECTIONTIMEOUT", connectionTimeout);
        velocityContext.put("SOCKETTIMEOUT", socketTimeout);
        velocityContext.put("LOGIN", login);
        velocityContext.put("PASSWORD", password);
        velocityContext.put("RESPONSELIFETIME", responselifetime);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String responselifetime;
        String password;
        String login;
        String socketTimeout;
        String connectionTimeout;
        String newgenericAddress = variableContext.getParameter("newgenericAddress");
        if (newgenericAddress != null) {
            parameters.setParameter("newGenericAddress", newgenericAddress);
        }
        if ((connectionTimeout = variableContext.getParameter("connectionTimeout")) != null) {
            parameters.setParameter("connectionTimeout", connectionTimeout);
        }
        if ((socketTimeout = variableContext.getParameter("socketTimeout")) != null) {
            parameters.setParameter("socketTimeout", socketTimeout);
        }
        if ((login = variableContext.getParameter("login")) != null) {
            parameters.setParameter("login", login);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setParameter("password", password);
        }
        if ((responselifetime = variableContext.getParameter("responselifetime")) != null) {
            parameters.setParameter("responselifetime", responselifetime);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        NewGenericAuthority.fillInServerTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIGURATION_AUTHORITY_HTML, velocityContext);
    }

    protected static class CheckThread
    extends Thread {
        protected HttpClient client;
        protected String url;
        protected Throwable exception = null;
        protected String result = "Unknown";

        public CheckThread(HttpClient client, String url) {
            this.setDaemon(true);
            this.client = client;
            this.url = url;
        }

        @Override
        public void run() {
            HttpGet method = new HttpGet(this.url);
            try {
                HttpResponse response = this.client.execute((HttpUriRequest)method);
                try {
                    if (response.getStatusLine().getStatusCode() != 200) {
                        this.result = "Connection failed: " + response.getStatusLine().getReasonPhrase();
                        return;
                    }
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    this.result = "Connection OK";
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    method.releaseConnection();
                }
            }
            catch (IOException ex) {
                this.exception = ex;
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        public String getResult() {
            return this.result;
        }
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        private Credentials credentials;

        public PreemptiveAuth(Credentials creds) {
            this.credentials = creds;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.addHeader(new BasicScheme(StandardCharsets.US_ASCII).authenticate(this.credentials, request, context));
        }
    }

    protected class GenericAuthorizationResponseDescription
    extends BaseDescription {
        protected String userName;
        protected String connectionString;
        protected long responseLifetime;
        protected long expirationTime;

        public GenericAuthorizationResponseDescription(String userName, String connectionString, long responseLifetime, int LRUsize) {
            super("LDAPAuthority", LRUsize);
            this.expirationTime = -1L;
            this.userName = userName;
            this.connectionString = connectionString;
            this.responseLifetime = responseLifetime;
        }

        public StringSet getObjectKeys() {
            return emptyStringSet;
        }

        public String getCriticalSectionName() {
            StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getName());
            sb.append("-").append(this.userName).append("-").append(this.connectionString);
            return sb.toString();
        }

        public long getObjectExpirationTime(long currentTime) {
            if (this.expirationTime == -1L) {
                this.expirationTime = currentTime + this.responseLifetime;
            }
            return this.expirationTime;
        }

        public int hashCode() {
            return this.userName.hashCode() + this.connectionString.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof GenericAuthorizationResponseDescription)) {
                return false;
            }
            GenericAuthorizationResponseDescription ard = (GenericAuthorizationResponseDescription)((Object)o);
            if (!ard.userName.equals(this.userName)) {
                return false;
            }
            return ard.connectionString.equals(this.connectionString);
        }
    }
}

