/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.transformationconnectorpool;

import org.apache.manifoldcf.agents.interfaces.ITransformationConnection;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectionManager;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnector;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectorManager;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectorPool;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectorManagerFactory;
import org.apache.manifoldcf.core.connectorpool.ConnectorPool;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class TransformationConnectorPool
implements ITransformationConnectorPool {
    public static final String _rcsid = "@(#)$Id$";
    protected static final LocalPool localPool = new LocalPool();
    protected final IThreadContext threadContext;

    public TransformationConnectorPool(IThreadContext threadContext) throws ManifoldCFException {
        this.threadContext = threadContext;
    }

    @Override
    public ITransformationConnector[] grabMultiple(String[] orderingKeys, ITransformationConnection[] transformationConnections) throws ManifoldCFException {
        String[] connectionNames = new String[transformationConnections.length];
        String[] classNames = new String[transformationConnections.length];
        ConfigParams[] configInfos = new ConfigParams[transformationConnections.length];
        int[] maxPoolSizes = new int[transformationConnections.length];
        for (int i = 0; i < transformationConnections.length; ++i) {
            connectionNames[i] = transformationConnections[i].getName();
            classNames[i] = transformationConnections[i].getClassName();
            configInfos[i] = transformationConnections[i].getConfigParams();
            maxPoolSizes[i] = transformationConnections[i].getMaxConnections();
        }
        return localPool.grabMultiple(this.threadContext, orderingKeys, connectionNames, classNames, configInfos, maxPoolSizes);
    }

    @Override
    public ITransformationConnector grab(ITransformationConnection transformationConnection) throws ManifoldCFException {
        return (ITransformationConnector)localPool.grab(this.threadContext, transformationConnection.getName(), transformationConnection.getClassName(), transformationConnection.getConfigParams(), transformationConnection.getMaxConnections());
    }

    @Override
    public void releaseMultiple(ITransformationConnection[] connections, ITransformationConnector[] connectors) throws ManifoldCFException {
        String[] connectionNames = new String[connections.length];
        for (int i = 0; i < connections.length; ++i) {
            connectionNames[i] = connections[i].getName();
        }
        localPool.releaseMultiple(this.threadContext, connectionNames, connectors);
    }

    @Override
    public void release(ITransformationConnection connection, ITransformationConnector connector) throws ManifoldCFException {
        localPool.release(this.threadContext, connection.getName(), connector);
    }

    @Override
    public void pollAllConnectors() throws ManifoldCFException {
        localPool.pollAllConnectors(this.threadContext);
    }

    @Override
    public void flushUnusedConnectors() throws ManifoldCFException {
        localPool.flushUnusedConnectors(this.threadContext);
    }

    @Override
    public void closeAllConnectors() throws ManifoldCFException {
        localPool.closeAllConnectors(this.threadContext);
    }

    protected static class LocalPool
    extends ConnectorPool<ITransformationConnector> {
        public LocalPool() {
            super("_TRANSFORMATIONCONNECTORPOOL_");
        }

        protected boolean isInstalled(IThreadContext tc, String className) throws ManifoldCFException {
            ITransformationConnectorManager connectorManager = TransformationConnectorManagerFactory.make(tc);
            return connectorManager.isInstalled(className);
        }

        protected boolean isConnectionNameValid(IThreadContext tc, String connectionName) throws ManifoldCFException {
            ITransformationConnectionManager connectionManager = TransformationConnectionManagerFactory.make(tc);
            return connectionManager.load(connectionName) != null;
        }

        public ITransformationConnector[] grabMultiple(IThreadContext tc, String[] orderingKeys, String[] connectionNames, String[] classNames, ConfigParams[] configInfos, int[] maxPoolSizes) throws ManifoldCFException {
            return (ITransformationConnector[])this.grabMultiple(tc, ITransformationConnector.class, orderingKeys, connectionNames, classNames, configInfos, maxPoolSizes);
        }
    }
}

