/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;

@InterfaceStability.Evolving
public class FenceProducersResult {
    private final Map<CoordinatorKey, KafkaFuture<ProducerIdAndEpoch>> futures;

    FenceProducersResult(Map<CoordinatorKey, KafkaFuture<ProducerIdAndEpoch>> futures) {
        this.futures = futures;
    }

    public Map<String, KafkaFuture<Void>> fencedProducers() {
        return this.futures.entrySet().stream().collect(Collectors.toMap(e -> ((CoordinatorKey)e.getKey()).idValue, e -> ((KafkaFuture)e.getValue()).thenApply(p -> null)));
    }

    public KafkaFuture<Long> producerId(String transactionalId) {
        return this.findAndApply(transactionalId, p -> p.producerId);
    }

    public KafkaFuture<Short> epochId(String transactionalId) {
        return this.findAndApply(transactionalId, p -> p.epoch);
    }

    public KafkaFuture<Void> all() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0]));
    }

    private <T> KafkaFuture<T> findAndApply(String transactionalId, KafkaFuture.BaseFunction<ProducerIdAndEpoch, T> followup) {
        CoordinatorKey key = CoordinatorKey.byTransactionalId(transactionalId);
        KafkaFuture<ProducerIdAndEpoch> future = this.futures.get(key);
        if (future == null) {
            throw new IllegalArgumentException("TransactionalId `" + transactionalId + "` was not included in the request");
        }
        return future.thenApply(followup);
    }
}

