/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authdomains;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.authorities.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.authorities.interfaces.IAuthorizationDomainManager;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;

public class AuthorizationDomainManager
extends BaseTable
implements IAuthorizationDomainManager {
    public static final String _rcsid = "@(#)$Id$";
    protected static final String descriptionField = "description";
    protected static final String domainNameField = "domainname";
    protected final IThreadContext threadContext;

    public AuthorizationDomainManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "authdomains");
        this.threadContext = threadContext;
    }

    @Override
    public void install() throws ManifoldCFException {
        block3: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(descriptionField, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
                map.put(domainNameField, new ColumnDescription("VARCHAR(255)", true, false, null, null, false));
                this.performCreate(map, null);
            }
            IndexDescription descriptionIndex = new IndexDescription(true, new String[]{descriptionField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (descriptionIndex != null && id.equals((Object)descriptionIndex)) {
                    descriptionIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (descriptionIndex == null) break block3;
            this.performAddIndex(null, descriptionIndex);
        }
    }

    @Override
    public void deinstall() throws ManifoldCFException {
        StringSet invKeys = new StringSet(this.getCacheKey());
        this.performDrop(invKeys);
    }

    @Override
    public void registerDomain(String description, String domainName) throws ManifoldCFException {
        StringSet invKeys = new StringSet(this.getCacheKey());
        this.beginTransaction();
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(domainName);
            IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE domainname=? FOR UPDATE", params, null, null);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(descriptionField, description);
            if (set.getRowCount() == 0) {
                map.put(domainNameField, domainName);
                this.performInsert(map, invKeys);
            } else {
                this.performUpdate(map, "WHERE domainname=?", params, invKeys);
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public void unregisterDomain(String domainName) throws ManifoldCFException {
        StringSet invKeys = new StringSet(this.getCacheKey());
        ArrayList<String> list = new ArrayList<String>();
        list.add(domainName);
        this.performDelete("WHERE domainname=?", list, invKeys);
    }

    @Override
    public IResultSet getDomains() throws ManifoldCFException {
        StringSet invKeys = new StringSet(this.getCacheKey());
        return this.performQuery("SELECT description AS description,domainname AS domainname FROM " + this.getTableName() + " ORDER BY description ASC", null, invKeys, null);
    }

    @Override
    public String getDescription(String domainName) throws ManifoldCFException {
        StringSet invKeys = new StringSet(this.getCacheKey());
        ArrayList<String> list = new ArrayList<String>();
        list.add(domainName);
        IResultSet set = this.performQuery("SELECT description FROM " + this.getTableName() + " WHERE domainname=?", list, invKeys, null);
        if (set.getRowCount() == 0) {
            return null;
        }
        IResultRow row = set.getRow(0);
        String x = (String)row.getValue(descriptionField);
        if (x == null) {
            return "";
        }
        return x;
    }

    protected String getCacheKey() {
        return CacheKeyFactory.makeTableKey(null, (String)this.getTableName(), (String)this.getDBInterface().getDatabaseName());
    }
}

