/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.constraint;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.constraint.DefaultConstraints;
import org.opengis.metadata.constraint.Classification;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.constraint.SecurityConstraints;
import org.opengis.util.InternationalString;

@XmlType(name="MD_SecurityConstraints_Type", propOrder={"classification", "userNote", "classificationSystem", "handlingDescription"})
@XmlRootElement(name="MD_SecurityConstraints")
public class DefaultSecurityConstraints
extends DefaultConstraints
implements SecurityConstraints {
    private static final long serialVersionUID = 621767670847345848L;
    private Classification classification;
    private InternationalString userNote;
    private InternationalString classificationSystem;
    private InternationalString handlingDescription;

    public DefaultSecurityConstraints() {
    }

    public DefaultSecurityConstraints(CharSequence charSequence) {
        super(charSequence);
    }

    public DefaultSecurityConstraints(Classification classification) {
        this.classification = classification;
    }

    public DefaultSecurityConstraints(SecurityConstraints securityConstraints) {
        super((Constraints)securityConstraints);
        if (securityConstraints != null) {
            this.classification = securityConstraints.getClassification();
            this.userNote = securityConstraints.getUserNote();
            this.classificationSystem = securityConstraints.getClassificationSystem();
            this.handlingDescription = securityConstraints.getHandlingDescription();
        }
    }

    public static DefaultSecurityConstraints castOrCopy(SecurityConstraints securityConstraints) {
        if (securityConstraints == null || securityConstraints instanceof DefaultSecurityConstraints) {
            return (DefaultSecurityConstraints)securityConstraints;
        }
        return new DefaultSecurityConstraints(securityConstraints);
    }

    @XmlElement(name="classification", required=true)
    public Classification getClassification() {
        return this.classification;
    }

    public void setClassification(Classification classification) {
        this.checkWritePermission(this.classification);
        this.classification = classification;
    }

    @XmlElement(name="userNote")
    public InternationalString getUserNote() {
        return this.userNote;
    }

    public void setUserNote(InternationalString internationalString) {
        this.checkWritePermission(this.userNote);
        this.userNote = internationalString;
    }

    @XmlElement(name="classificationSystem")
    public InternationalString getClassificationSystem() {
        return this.classificationSystem;
    }

    public void setClassificationSystem(InternationalString internationalString) {
        this.checkWritePermission(this.classificationSystem);
        this.classificationSystem = internationalString;
    }

    @XmlElement(name="handlingDescription")
    public InternationalString getHandlingDescription() {
        return this.handlingDescription;
    }

    public void setHandlingDescription(InternationalString internationalString) {
        this.checkWritePermission(this.handlingDescription);
        this.handlingDescription = internationalString;
    }
}

