/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.service.impl;

import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UIMA_UnsupportedOperationException;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.AnalysisEngineServiceStub;
import org.apache.uima.analysis_engine.CasIterator;
import org.apache.uima.analysis_engine.TextAnalysisEngine;
import org.apache.uima.analysis_engine.impl.AnalysisEngineImplBase;
import org.apache.uima.analysis_engine.impl.EmptyCasIterator;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceServiceException;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.Level;
import org.apache.uima.util.UimaTimer;

public abstract class AnalysisEngineServiceAdapter
extends AnalysisEngineImplBase
implements TextAnalysisEngine,
CasConsumer {
    private static final Class<AnalysisEngineServiceAdapter> CLASS_NAME = AnalysisEngineServiceAdapter.class;
    private AnalysisEngineServiceStub mStub;
    private ResourceMetaData mCachedMetaData;
    private UimaTimer mTimer = UIMAFramework.newTimer();

    protected void setStub(AnalysisEngineServiceStub aStub) {
        this.mStub = aStub;
    }

    protected AnalysisEngineServiceStub getStub() {
        return this.mStub;
    }

    @Override
    public ResourceMetaData getMetaData() {
        try {
            if (this.mCachedMetaData == null && this.getStub() != null) {
                this.mCachedMetaData = this.getStub().callGetMetaData();
            }
            return this.mCachedMetaData;
        }
        catch (ResourceServiceException e) {
            throw new UIMARuntimeException(e);
        }
    }

    @Override
    public void destroy() {
        if (this.getStub() != null) {
            this.getStub().destroy();
        }
        super.destroy();
    }

    @Override
    public CasIterator processAndOutputNewCASes(CAS aCAS) throws AnalysisEngineProcessException {
        this.mTimer.startIt();
        UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "process", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_process_begin__FINE", this.getResourceName());
        try {
            this.getStub().callProcess(aCAS);
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "process", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_process_end__FINE", this.getResourceName());
            EmptyCasIterator emptyCasIterator = new EmptyCasIterator();
            return emptyCasIterator;
        }
        catch (Exception e) {
            UIMAFramework.getLogger(CLASS_NAME).log(Level.SEVERE, "", e);
            throw new AnalysisEngineProcessException(e);
        }
        finally {
            this.mTimer.stopIt();
            this.getMBean().reportServiceCallTime((int)this.mTimer.getDuration());
            this.getMBean().incrementCASesProcessed();
        }
    }

    @Override
    public void reconfigure() throws ResourceConfigurationException {
        throw new UIMA_UnsupportedOperationException("shared_resource_not_reconfigurable", new Object[0]);
    }

    @Override
    public Object getConfigParameterValue(String aGroupName, String aParamName) {
        return this.getMetaData().getConfigurationParameterSettings().getParameterValue(aGroupName, aParamName);
    }

    @Override
    public Object getConfigParameterValue(String aParamName) {
        return this.getMetaData().getConfigurationParameterSettings().getParameterValue(aParamName);
    }

    @Override
    public void setConfigParameterValue(String aParamName, Object aValue) {
        throw new UIMA_UnsupportedOperationException("shared_resource_not_reconfigurable", new Object[0]);
    }

    @Override
    public void setConfigParameterValue(String aGroupName, String aParamName, Object aValue) {
        throw new UIMA_UnsupportedOperationException("shared_resource_not_reconfigurable", new Object[0]);
    }

    @Override
    public void batchProcessComplete() throws AnalysisEngineProcessException {
        try {
            this.getStub().callBatchProcessComplete();
        }
        catch (ResourceServiceException e) {
            throw new AnalysisEngineProcessException(e);
        }
    }

    @Override
    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        try {
            this.getStub().callCollectionProcessComplete();
        }
        catch (ResourceServiceException e) {
            throw new AnalysisEngineProcessException(e);
        }
    }

    protected String getResourceName() {
        return this.getMetaData().getName();
    }
}

