/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.LinkedHashSet;
import org.apache.sis.internal.util.CheckedArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.collection.CheckedContainer;

public final class CheckedHashSet<E>
extends LinkedHashSet<E>
implements CheckedContainer<E> {
    private static final long serialVersionUID = 1999408533884863599L;
    private final Class<E> type;

    public CheckedHashSet(Class<E> clazz) {
        this.type = clazz;
        ArgumentChecks.ensureNonNull("type", clazz);
    }

    public CheckedHashSet(Class<E> clazz, int n) {
        super(n);
        this.type = clazz;
        ArgumentChecks.ensureNonNull("type", clazz);
    }

    @Override
    public Class<E> getElementType() {
        return this.type;
    }

    @Override
    public boolean add(E e) throws IllegalArgumentException {
        if (this.type.isInstance(e)) {
            return super.add(e);
        }
        String string = CheckedArrayList.illegalElement(this, e, this.type);
        if (string == null) {
            return false;
        }
        if (e == null) {
            throw new NullArgumentException(string);
        }
        throw new IllegalArgumentException(string);
    }
}

