/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.cache.impl;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Stream;
import org.mvndaemon.mvnd.cache.Cache;
import org.mvndaemon.mvnd.cache.CacheFactory;
import org.mvndaemon.mvnd.cache.CacheRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchServiceCacheFactory
implements CacheFactory {
    private static final Logger LOG = LoggerFactory.getLogger(WatchServiceCacheFactory.class);
    private final WatchService watchService;
    private final Map<Path, List<CacheRecord>> recordsByPath = new ConcurrentHashMap<Path, List<CacheRecord>>();
    private final Map<Path, Registration> registrationsByDir = new ConcurrentHashMap<Path, Registration>();

    public WatchServiceCacheFactory() {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void add(CacheRecord record) {
        record.getDependencyPaths().forEach(p -> {
            List records;
            List list = records = this.recordsByPath.computeIfAbsent((Path)p, k -> new ArrayList());
            synchronized (list) {
                records.add(record);
                this.registrationsByDir.compute(p.getParent(), this::register);
            }
        });
    }

    @Override
    public <K, V extends CacheRecord> Cache<K, V> newCache() {
        return new WatchServiceCache();
    }

    private Registration register(Path key, Registration value) {
        if (value == null) {
            LOG.debug("Starting to watch path {}", (Object)key);
            try {
                WatchEvent.Modifier[] mods;
                try {
                    mods = new WatchEvent.Modifier[]{SensitivityWatchEventModifier.HIGH};
                }
                catch (Throwable t) {
                    mods = null;
                }
                WatchKey watchKey = key.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY}, mods);
                return new Registration(watchKey);
            }
            catch (NoSuchFileException e) {
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        int cnt = value.count.incrementAndGet();
        LOG.debug("Already {} watchers for path {}", (Object)cnt, (Object)key);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateRecords() {
        for (Map.Entry<Path, Registration> entry : this.registrationsByDir.entrySet()) {
            WatchKey watchKey = entry.getValue().watchKey;
            for (WatchEvent<?> event : watchKey.pollEvents()) {
                Path dir = entry.getKey();
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.ENTRY_DELETE || kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                    Path path = dir.resolve((Path)event.context());
                    LOG.debug("Got watcher event {} for file {}", (Object)kind.name(), (Object)path);
                    List<CacheRecord> records = this.recordsByPath.remove(path);
                    if (records == null) continue;
                    List<CacheRecord> list = records;
                    synchronized (list) {
                        LOG.debug("Invalidating records for path {}: {}", (Object)path, records);
                        this.remove(records);
                        continue;
                    }
                }
                if (kind != StandardWatchEventKinds.OVERFLOW) continue;
                LOG.debug("Got overflow event for path {}", (Object)dir);
                Iterator<Map.Entry<Path, List<CacheRecord>>> it = this.recordsByPath.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Path, List<CacheRecord>> en = it.next();
                    Path path = en.getKey();
                    if (!path.getParent().equals(dir)) continue;
                    it.remove();
                    List<CacheRecord> records = en.getValue();
                    if (records == null) continue;
                    List<CacheRecord> list = records;
                    synchronized (list) {
                        LOG.debug("Invalidating records of path {}: {}", (Object)path, records);
                        this.remove(records);
                    }
                }
            }
        }
    }

    void remove(List<CacheRecord> records) {
        for (CacheRecord record : records) {
            record.invalidate();
            record.getDependencyPaths().map(Path::getParent).forEach(dir -> this.registrationsByDir.compute((Path)dir, this::unregister));
        }
    }

    private Registration unregister(Path key, Registration value) {
        if (value == null) {
            LOG.debug("Already stopped watching path {}", (Object)key);
            return null;
        }
        int cnt = value.count.decrementAndGet();
        if (cnt <= 0) {
            LOG.debug("Unwatching path {}", (Object)key);
            value.watchKey.cancel();
            return null;
        }
        LOG.debug("Still " + cnt + " watchers for path {}", (Object)key);
        return value;
    }

    class WatchServiceCache<K, V extends CacheRecord>
    implements Cache<K, V> {
        private final ConcurrentHashMap<K, V> map = new ConcurrentHashMap();

        WatchServiceCache() {
        }

        @Override
        public boolean contains(K key) {
            return this.get(key) != null;
        }

        @Override
        public V get(K key) {
            WatchServiceCacheFactory.this.validateRecords();
            return (V)((CacheRecord)this.map.get(key));
        }

        @Override
        public void put(K key, V value) {
            WatchServiceCacheFactory.this.add(new WrappedCacheRecord<K, V>(this.map, key, value));
            this.map.put(key, value);
        }

        @Override
        public void clear() {
            this.removeIf((k, v) -> true);
        }

        @Override
        public void removeIf(BiPredicate<K, V> predicate) {
            Iterator<Map.Entry<K, V>> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (!predicate.test(entry.getKey(), (CacheRecord)entry.getValue())) continue;
                ((CacheRecord)entry.getValue()).invalidate();
                iterator.remove();
            }
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            WatchServiceCacheFactory.this.validateRecords();
            return (V)this.map.computeIfAbsent(key, k -> {
                CacheRecord v = (CacheRecord)mappingFunction.apply((K)k);
                WatchServiceCacheFactory.this.add(new WrappedCacheRecord<Object, CacheRecord>(this.map, k, v));
                return v;
            });
        }
    }

    static class Registration {
        final AtomicInteger count = new AtomicInteger(1);
        final WatchKey watchKey;

        Registration(WatchKey watchKey) {
            this.watchKey = watchKey;
        }
    }

    static class WrappedCacheRecord<K, V extends CacheRecord>
    implements CacheRecord {
        private final Map<K, V> map;
        private final K key;
        private final V delegate;

        public WrappedCacheRecord(Map<K, V> map, K key, V delegate) {
            this.map = map;
            this.key = key;
            this.delegate = delegate;
        }

        @Override
        public Stream<Path> getDependencyPaths() {
            return this.delegate.getDependencyPaths();
        }

        @Override
        public void invalidate() {
            this.delegate.invalidate();
            this.map.remove(this.key);
        }
    }
}

