/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.configuration.internal;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.configuration.BeanConfigurationException;
import org.apache.maven.configuration.BeanConfigurationPathTranslator;
import org.apache.maven.configuration.BeanConfigurationRequest;
import org.apache.maven.configuration.BeanConfigurationValuePreprocessor;
import org.apache.maven.configuration.BeanConfigurator;
import org.apache.maven.configuration.internal.EnhancedConfigurationConverter;
import org.apache.maven.configuration.internal.EnhancedConverterLookup;
import org.apache.maven.internal.xml.XmlNodeImpl;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.basic.AbstractBasicConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Named
@Singleton
public class DefaultBeanConfigurator
implements BeanConfigurator {
    private final ConverterLookup converterLookup = new EnhancedConverterLookup();

    @Override
    public void configureBean(BeanConfigurationRequest request) throws BeanConfigurationException {
        ClassLoader classLoader;
        PlexusConfiguration plexusConfig;
        Objects.requireNonNull(request, "request cannot be null");
        Objects.requireNonNull(request.getBean(), "request.bean cannot be null");
        Object configuration = request.getConfiguration();
        if (configuration == null) {
            return;
        }
        if (configuration instanceof PlexusConfiguration) {
            PlexusConfiguration plexusConfiguration;
            plexusConfig = plexusConfiguration = (PlexusConfiguration)configuration;
        } else if (configuration instanceof Xpp3Dom) {
            Xpp3Dom xpp3Dom = (Xpp3Dom)configuration;
            plexusConfig = new XmlPlexusConfiguration(xpp3Dom);
        } else {
            throw new BeanConfigurationException("unsupported bean configuration source (" + configuration.getClass().getName() + ")");
        }
        if (request.getConfigurationElement() != null) {
            plexusConfig = plexusConfig.getChild(request.getConfigurationElement());
        }
        if ((classLoader = request.getClassLoader()) == null) {
            classLoader = request.getBean().getClass().getClassLoader();
        }
        BeanExpressionEvaluator evaluator = new BeanExpressionEvaluator(request);
        EnhancedConfigurationConverter converter = new EnhancedConfigurationConverter();
        try {
            converter.processConfiguration(this.converterLookup, request.getBean(), classLoader, plexusConfig, (ExpressionEvaluator)evaluator, null);
        }
        catch (ComponentConfigurationException e) {
            throw new BeanConfigurationException(e.getMessage(), e);
        }
    }

    static class BeanExpressionEvaluator
    implements TypeAwareExpressionEvaluator {
        private final BeanConfigurationValuePreprocessor preprocessor;
        private final BeanConfigurationPathTranslator translator;

        BeanExpressionEvaluator(BeanConfigurationRequest request) {
            this.preprocessor = request.getValuePreprocessor();
            this.translator = request.getPathTranslator();
        }

        public Object evaluate(String expression, Class<?> type) throws ExpressionEvaluationException {
            if (this.preprocessor != null) {
                try {
                    return this.preprocessor.preprocessValue(expression, type);
                }
                catch (BeanConfigurationException e) {
                    throw new ExpressionEvaluationException(e.getMessage(), (Throwable)e);
                }
            }
            return expression;
        }

        public Object evaluate(String expression) throws ExpressionEvaluationException {
            return this.evaluate(expression, null);
        }

        public File alignToBaseDirectory(File file) {
            if (this.translator != null) {
                return this.translator.translatePath(file);
            }
            return file;
        }
    }

    static class PathConverter
    extends AbstractBasicConverter {
        PathConverter() {
        }

        public boolean canConvert(Class<?> type) {
            return Path.class.equals(type);
        }

        protected Object fromString(String value) throws ComponentConfigurationException {
            return Paths.get(value.replace('/' == File.separatorChar ? (char)'\\' : '/', File.separatorChar), new String[0]);
        }

        public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
            Object object;
            Object result = super.fromConfiguration(lookup, configuration, type, enclosingType, loader, evaluator, listener);
            if (result instanceof Path) {
                Path path = (Path)result;
                object = evaluator.alignToBaseDirectory(path.toFile()).toPath();
            } else {
                object = result;
            }
            return object;
        }
    }

    static class XmlConverter
    extends AbstractConfigurationConverter {
        XmlConverter() {
        }

        public boolean canConvert(Class<?> type) {
            return XmlNode.class.equals(type);
        }

        public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
            try {
                return this.toXml(configuration, evaluator);
            }
            catch (ExpressionEvaluationException e) {
                throw new ComponentConfigurationException("Unable to convert configuration to xml node", (Throwable)e);
            }
        }

        XmlNode toXml(PlexusConfiguration config, ExpressionEvaluator evaluator) throws ExpressionEvaluationException {
            ArrayList<XmlNode> children = new ArrayList<XmlNode>();
            for (PlexusConfiguration c : config.getChildren()) {
                children.add(this.toXml(c, evaluator));
            }
            String name = config.getName();
            Object value = evaluator.evaluate(config.getValue());
            return new XmlNodeImpl(name, value != null ? value.toString() : null, null, children, null);
        }
    }
}

