/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.git.transport;

import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.git.GitModuleProperties;
import org.apache.sshd.git.transport.GitSshdSessionProcess;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;

public class GitSshdSession
extends AbstractLoggingBean
implements RemoteSession {
    private final SshClient client;
    private final ClientSession session;

    public GitSshdSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws IOException, InterruptedException {
        CredentialItem.Password pwdItem;
        CredentialItem.Username usrItem;
        String user = uri.getUser();
        String pass1 = uri.getPass();
        String host = uri.getHost();
        int port = uri.getPort();
        char[] pass2 = null;
        if (!credentialsProvider.isInteractive() && credentialsProvider.get(uri, new CredentialItem[]{usrItem = new CredentialItem.Username(), pwdItem = new CredentialItem.Password()})) {
            if (user == null) {
                user = usrItem.getValue();
            } else if (user.equals(usrItem.getValue())) {
                pass2 = pwdItem.getValue();
            }
        }
        this.client = this.createClient();
        try {
            if (!this.client.isStarted()) {
                this.client.start();
            }
            this.session = this.createClientSession(this.client, host, user, port, pass1, pass2 != null ? new String(pass2) : null);
        }
        catch (IOException | InterruptedException e) {
            this.disconnectClient(this.client);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientSession createClientSession(SshClient clientInstance, String host, String username, int port, String ... passwords) throws IOException, InterruptedException {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("Connecting to {}:{}", (Object)host, (Object)port);
        }
        ClientSession s = (ClientSession)((ConnectFuture)clientInstance.connect(username, host, port).verify((Duration)GitModuleProperties.CONNECT_TIMEOUT.getRequired((PropertyResolver)clientInstance), new CancelOption[0])).getSession();
        if (debugEnabled) {
            this.log.debug("Connected to {}:{}", (Object)host, (Object)port);
        }
        try {
            if (passwords == null) {
                passwords = GenericUtils.EMPTY_STRING_ARRAY;
            }
            for (String p : passwords) {
                if (p == null) continue;
                s.addPasswordIdentity(p);
            }
            if (debugEnabled) {
                this.log.debug("Authenticating: {}", (Object)s);
            }
            s.auth().verify((Duration)GitModuleProperties.AUTH_TIMEOUT.getRequired((PropertyResolver)s), new CancelOption[0]);
            if (debugEnabled) {
                this.log.debug("Authenticated: {}", (Object)s);
            }
            ClientSession result = s;
            s = null;
            ClientSession clientSession = result;
            return clientSession;
        }
        finally {
            if (s != null) {
                s.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process exec(String commandName, int timeout) throws IOException {
        ChannelExec channel;
        Optional protocolVer;
        String protocol;
        boolean traceEnabled = this.log.isTraceEnabled();
        if (traceEnabled) {
            this.log.trace("exec({}) session={}, timeout={} sec.", new Object[]{commandName, this.session, timeout});
        }
        if (GenericUtils.isNotBlank((CharSequence)(protocol = (String)(protocolVer = GitModuleProperties.GIT_PROTOCOL_VERSION.get((PropertyResolver)this.session)).orElse(null)))) {
            Map<String, String> env = Collections.singletonMap("GIT_PROTOCOL", protocol);
            channel = this.session.createExecChannel(commandName, null, env);
        } else {
            channel = this.session.createExecChannel(commandName);
        }
        if (traceEnabled) {
            this.log.trace("exec({}) session={} - open channel", (Object)commandName, (Object)this.session);
        }
        try {
            channel.open().verify((Duration)GitModuleProperties.CHANNEL_OPEN_TIMEOUT.getRequired((PropertyResolver)channel), new CancelOption[0]);
            if (traceEnabled) {
                this.log.trace("exec({}) session={} - channel open", (Object)commandName, (Object)this.session);
            }
            GitSshdSessionProcess process = new GitSshdSessionProcess(channel, commandName, timeout);
            channel = null;
            GitSshdSessionProcess gitSshdSessionProcess = process;
            return gitSshdSessionProcess;
        }
        finally {
            if (channel != null) {
                channel.close(true);
            }
        }
    }

    public void disconnect() {
        try {
            this.disconnectSession(this.session);
        }
        finally {
            this.disconnectClient(this.client);
        }
    }

    protected void disconnectSession(ClientSession sessionInstance) {
        if (sessionInstance == null || !sessionInstance.isOpen()) {
            return;
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("Disconnecting from {}", (Object)sessionInstance);
        }
        sessionInstance.close(true);
        if (debugEnabled) {
            this.log.debug("Disconnected from {}", (Object)sessionInstance);
        }
    }

    protected void disconnectClient(SshClient clientInstance) {
        if (clientInstance == null || !clientInstance.isStarted()) {
            return;
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("Stopping {}", (Object)clientInstance);
        }
        clientInstance.stop();
        if (debugEnabled) {
            this.log.debug("Stopped {}", (Object)clientInstance);
        }
    }

    protected SshClient createClient() {
        return SshClient.setUpDefaultClient();
    }
}

