/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.Closeable;
import java.io.IOException;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.io.IoUtils;

public class SimpleIoOutputStream
extends AbstractCloseable
implements IoOutputStream {
    protected final ChannelOutputStream os;

    public SimpleIoOutputStream(ChannelOutputStream os) {
        this.os = os;
    }

    protected void doCloseImmediately() {
        IoUtils.closeQuietly((Closeable)this.os);
        super.doCloseImmediately();
    }

    public IoWriteFuture writeBuffer(Buffer buffer) throws IOException {
        this.os.write(buffer.array(), buffer.rpos(), buffer.available());
        this.os.flush();
        DefaultIoWriteFuture f = new DefaultIoWriteFuture((Object)this, null);
        f.setValue(true);
        return f;
    }

    protected static class DefaultIoWriteFuture
    extends AbstractIoWriteFuture {
        public DefaultIoWriteFuture(Object id, Object lock) {
            super(id, lock);
        }
    }
}

