/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.core.sasl.handler;

import java.util.List;
import org.apache.vysper.xmpp.authorization.SASLMechanism;
import org.apache.vysper.xmpp.modules.core.sasl.AuthorizationRetriesCounter;
import org.apache.vysper.xmpp.modules.core.sasl.handler.AbstractSASLHandler;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainer;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainerImpl;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.stanza.Stanza;

public class AuthHandler
extends AbstractSASLHandler {
    public String getName() {
        return "auth";
    }

    public boolean isSessionRequired() {
        return true;
    }

    protected ResponseStanzaContainer executeWorker(Stanza stanza, SessionContext sessionContext, SessionStateHolder sessionStateHolder) {
        String requestedMechanism = stanza.getAttributeValue("mechanism");
        if (requestedMechanism == null) {
            return this.respondSASLFailure();
        }
        SASLMechanism identifiedMechanism = null;
        List<SASLMechanism> list = sessionContext.getServerRuntimeContext().getServerFeatures().getAuthenticationMethods();
        for (SASLMechanism saslMechanism : list) {
            if (!saslMechanism.getName().equals(requestedMechanism)) continue;
            identifiedMechanism = saslMechanism;
            break;
        }
        if (identifiedMechanism == null) {
            throw new RuntimeException("return error");
        }
        Stanza responseStanza = identifiedMechanism.started(sessionContext, sessionStateHolder, stanza);
        if (sessionStateHolder.getState() == SessionState.AUTHENTICATED) {
            AuthorizationRetriesCounter.removeFromSession(sessionContext);
        } else {
            AuthorizationRetriesCounter.getFromSession(sessionContext).countFailedTry();
        }
        return new ResponseStanzaContainerImpl(responseStanza);
    }
}

