/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class DB2LengthOperatorNode
extends UnaryOperatorNode {
    public void init(Object object) {
        super.init(object, "length", "getDB2Length");
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        ValueNode valueNode = super.bindExpression(fromList, subqueryList, vector);
        TypeId typeId = this.operand.getTypeId();
        if (typeId.isXMLTypeId()) {
            throw StandardException.newException("42X25", (Object)this.getOperatorString(), (Object)typeId.getSQLTypeName());
        }
        this.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(4), this.operand.getTypeServices().isNullable()));
        return valueNode;
    }

    public String getReceiverInterfaceName() {
        return "org.apache.derby.iapi.types.ConcatableDataValue";
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.operand == null) {
            return;
        }
        int n = this.getConstantLength();
        String string = this.getTypeCompiler().interfaceName();
        methodBuilder.pushThis();
        this.operand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        methodBuilder.push(n);
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string);
        methodBuilder.getField(localField);
        methodBuilder.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", this.methodName, string, 3);
        methodBuilder.putField(localField);
    }

    private int getConstantLength() throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = this.operand.getTypeServices();
        switch (dataTypeDescriptor.getJDBCTypeId()) {
            case -5: {
                return 8;
            }
            case -7: 
            case 16: {
                return 1;
            }
            case -2: 
            case 1: {
                return dataTypeDescriptor.getMaximumWidth();
            }
            case 91: {
                return 4;
            }
            case 2: 
            case 3: {
                return dataTypeDescriptor.getPrecision() / 2 + 1;
            }
            case 8: {
                return 8;
            }
            case 4: 
            case 6: 
            case 7: {
                return 4;
            }
            case 5: {
                return 2;
            }
            case 92: {
                return 3;
            }
            case 93: {
                return 10;
            }
            case -6: {
                return 1;
            }
            case -4: 
            case -3: 
            case -1: 
            case 12: 
            case 2004: {
                return this.getConstantNodeLength();
            }
        }
        return -1;
    }

    private int getConstantNodeLength() throws StandardException {
        if (this.operand instanceof ConstantNode) {
            return ((ConstantNode)this.operand).getValue().getLength();
        }
        return -1;
    }
}

