/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc.stanzas;

import java.util.ArrayList;
import java.util.List;
import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLSemanticError;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Affiliation;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Role;
import org.apache.vysper.xmpp.stanza.IQStanza;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IqAdminItem
extends XMLElement {
    public static List<IqAdminItem> extractItems(IQStanza stanza) throws XMLSemanticError, EntityFormatException {
        XMLElement query = stanza.getSingleInnerElementsNamed("query", "http://jabber.org/protocol/muc#admin");
        List itemElms = query.getInnerElementsNamed("item", "http://jabber.org/protocol/muc#admin");
        ArrayList<IqAdminItem> items = new ArrayList<IqAdminItem>();
        for (XMLElement itemElm : itemElms) {
            items.add(IqAdminItem.getWrapper(itemElm));
        }
        return items;
    }

    public static IqAdminItem getWrapper(XMLElement itemElm) throws EntityFormatException {
        String nick = itemElm.getAttributeValue("nick");
        String jidStr = itemElm.getAttributeValue("jid");
        EntityImpl jid = null;
        if (jidStr != null) {
            jid = EntityImpl.parse((String)jidStr);
        }
        String roleStr = itemElm.getAttributeValue("role");
        Role role = null;
        if (roleStr != null) {
            role = Role.fromString(roleStr);
        }
        String affiliationStr = itemElm.getAttributeValue("affiliation");
        Affiliation affiliation = null;
        if (affiliationStr != null) {
            affiliation = Affiliation.fromString(affiliationStr);
        }
        return new IqAdminItem(nick, (Entity)jid, role, affiliation);
    }

    public IqAdminItem(String nick, Role role) {
        super("http://jabber.org/protocol/muc#admin", "item", null, IqAdminItem.createAttributes(nick, null, role, null), null);
    }

    public IqAdminItem(String nick, Affiliation affiliation) {
        super("http://jabber.org/protocol/muc#admin", "item", null, IqAdminItem.createAttributes(nick, null, null, affiliation), null);
    }

    public IqAdminItem(Entity jid, Affiliation affiliation) {
        super("http://jabber.org/protocol/muc#admin", "item", null, IqAdminItem.createAttributes(null, jid, null, affiliation), null);
    }

    public IqAdminItem(String nick, Entity jid, Role role, Affiliation affiliation) {
        super("http://jabber.org/protocol/muc#admin", "item", null, IqAdminItem.createAttributes(nick, jid, role, affiliation), null);
    }

    public String getNick() {
        return this.getAttributeValue("nick");
    }

    public Entity getJid() throws EntityFormatException {
        String jidStr = this.getAttributeValue("jid");
        Object jid = null;
        if (jidStr != null) {
            return EntityImpl.parse((String)jidStr);
        }
        return null;
    }

    public Role getRole() {
        String value = this.getAttributeValue("role");
        if (value != null) {
            return Role.fromString(value);
        }
        return null;
    }

    public Affiliation getAffiliation() {
        String value = this.getAttributeValue("affiliation");
        if (value != null) {
            return Affiliation.fromString(value);
        }
        return null;
    }

    private static List<Attribute> createAttributes(String nick, Entity jid, Role role, Affiliation affiliation) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (nick != null) {
            attributes.add(new Attribute("nick", nick));
        }
        if (jid != null) {
            attributes.add(new Attribute("jid", jid.getFullQualifiedName()));
        }
        if (role != null) {
            attributes.add(new Attribute("role", role.toString()));
        }
        if (affiliation != null) {
            attributes.add(new Attribute("affiliation", affiliation.toString()));
        }
        return attributes;
    }
}

