/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec.postscript;

import com.lowagie.text.pdf.codec.postscript.PACommand;
import com.lowagie.text.pdf.codec.postscript.PAContext;
import com.lowagie.text.pdf.codec.postscript.PAToken;
import com.lowagie.text.pdf.codec.postscript.PainterException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class PAEngine {
    public static final int MODE_STACK = 0;
    public static final int MODE_PROCEDURE = 1;
    public static final int MODE_ARRAY = 2;
    protected PAContext context;
    protected int mode;
    protected Stack procedure;
    protected int innerProcedures;

    public PAEngine(PAContext context) {
        this.context = context;
        this.mode = 0;
    }

    public void startProcedure() {
        this.procedure = new Stack();
        this.mode = 1;
        this.innerProcedures = 0;
    }

    public void endProcedure() {
        this.context.operands.push(new PAToken(this.procedure, 2));
        this.mode = 0;
    }

    public void bindProcedure(PAToken patoken) {
        Stack oldStack = (Stack)patoken.value;
        Stack<Object> newStack = new Stack<Object>();
        int n = oldStack.size();
        int i = 0;
        while (i < n) {
            Object token = oldStack.elementAt(i);
            if (token instanceof PAToken && ((PAToken)token).type == 0) {
                Object foundToken = this.context.findIdentifier(((PAToken)token).value);
                if (foundToken == null) {
                    newStack.push(token);
                } else {
                    newStack.push(foundToken);
                }
            } else {
                newStack.push(token);
            }
            ++i;
        }
        patoken.value = newStack;
    }

    public void process(Object token) throws PainterException {
        block23: {
            block21: {
                block24: {
                    block22: {
                        if (token == null) {
                            throw new IllegalStateException("Null token encountered; last unknown identifier was " + this.context.getLastUnknownIdentifier() + " at line " + this.context.poorscript.token.beginLine);
                        }
                        if (PAContext.DebugExecution) {
                            System.out.print("==>" + token.toString());
                        }
                        if (token instanceof PAToken && ((PAToken)token).type == 6) {
                            Object foundValue = this.context.findIdentifier(((PAToken)token).value);
                            this.process(foundValue);
                            return;
                        }
                        if (this.mode != 0) break block21;
                        if (!(token instanceof PACommand)) break block22;
                        ((PACommand)token).execute(this.context);
                        break block23;
                    }
                    if (!(token instanceof PAToken)) break block24;
                    PAToken patoken = (PAToken)token;
                    switch (patoken.type) {
                        case 0: {
                            this.process(this.context.findIdentifier(patoken.value));
                            break block23;
                        }
                        case 1: 
                        case 3: 
                        case 7: {
                            this.context.operands.push(token);
                            break block23;
                        }
                        case 2: {
                            Enumeration enumx = ((Vector)patoken.value).elements();
                            while (enumx.hasMoreElements()) {
                                this.process(enumx.nextElement());
                            }
                            break block23;
                        }
                        case 4: {
                            this.startProcedure();
                            break block23;
                        }
                        case 8: {
                            this.context.collectArray();
                            break block23;
                        }
                        case 9: {
                            this.context.operands.push(token);
                            break block23;
                        }
                        case 10: {
                            this.context.collectDict();
                            break block23;
                        }
                        default: {
                            throw new IllegalStateException("Unknown token encountered" + token);
                        }
                    }
                }
                this.context.operands.push(token);
                break block23;
            }
            if (this.mode == 1) {
                if (token instanceof PAToken) {
                    PAToken patoken = (PAToken)token;
                    switch (patoken.type) {
                        case 4: {
                            ++this.innerProcedures;
                            this.procedure.push(token);
                            break;
                        }
                        case 5: {
                            if (this.innerProcedures > 0) {
                                --this.innerProcedures;
                                this.procedure.push(token);
                                break;
                            }
                            this.endProcedure();
                            break;
                        }
                        default: {
                            this.procedure.push(token);
                            break;
                        }
                    }
                } else {
                    this.procedure.push(token);
                }
            }
        }
    }

    public String litMode() {
        switch (this.mode) {
            case 2: {
                return "Array";
            }
            case 1: {
                return "Proc" + this.innerProcedures;
            }
            case 0: {
                return "Stack";
            }
        }
        return "Unknown";
    }
}

