/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

class _SharedRendererUtils {
    _SharedRendererUtils() {
    }

    static Converter findUIOutputConverter(FacesContext facesContext, UIOutput component) {
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression expression = component.getValueExpression("value");
        if (expression == null) {
            return null;
        }
        Class valueType = expression.getType(facesContext.getELContext());
        if (valueType == null) {
            return null;
        }
        if (Object.class.equals((Object)valueType)) {
            return null;
        }
        try {
            return facesContext.getApplication().createConverter(valueType);
        }
        catch (FacesException e) {
            _SharedRendererUtils.log(facesContext, "No Converter for type " + valueType.getName() + " found", e);
            return null;
        }
    }

    static Object getConvertedUISelectManyValue(FacesContext facesContext, UISelectMany component, String[] submittedValue) throws ConverterException {
        Converter converter;
        if (submittedValue == null) {
            throw new NullPointerException("submittedValue");
        }
        ValueExpression expression = component.getValueExpression("value");
        Class valueType = null;
        Class<?> arrayComponentType = null;
        if (expression != null) {
            Object value = expression.getValue(facesContext.getELContext());
            Class clazz = valueType = value != null ? value.getClass() : expression.getType(facesContext.getELContext());
            if (valueType != null && valueType.isArray()) {
                arrayComponentType = valueType.getComponentType();
            }
        }
        if ((converter = component.getConverter()) == null) {
            if (valueType == null) {
                return submittedValue;
            }
            if (List.class.isAssignableFrom(valueType)) {
                int len = submittedValue.length;
                ArrayList<String> lst = new ArrayList<String>(len);
                for (int i = 0; i < len; ++i) {
                    lst.add(submittedValue[i]);
                }
                return lst;
            }
            if (arrayComponentType == null) {
                throw new IllegalArgumentException("ValueBinding for UISelectMany must be of type List or Array");
            }
            if (Object.class.equals(arrayComponentType)) {
                return submittedValue;
            }
            converter = facesContext.getApplication().createConverter(arrayComponentType);
            if (converter == null) {
                return submittedValue;
            }
        }
        if (expression != null && (valueType = expression.getType(facesContext.getELContext())) != null && valueType.isArray() && submittedValue.length > 0) {
            arrayComponentType = converter.getAsObject(facesContext, component, submittedValue[0]).getClass();
        }
        if (valueType == null) {
            int len = submittedValue.length;
            Object[] convertedValues = (Object[])Array.newInstance(arrayComponentType == null ? Object.class : arrayComponentType, len);
            for (int i = 0; i < len; ++i) {
                convertedValues[i] = converter.getAsObject(facesContext, component, submittedValue[i]);
            }
            return convertedValues;
        }
        if (List.class.isAssignableFrom(valueType)) {
            int len = submittedValue.length;
            ArrayList<Object> lst = new ArrayList<Object>(len);
            for (int i = 0; i < len; ++i) {
                lst.add(converter.getAsObject(facesContext, component, submittedValue[i]));
            }
            return lst;
        }
        if (arrayComponentType == null) {
            throw new IllegalArgumentException("ValueBinding for UISelectMany must be of type List or Array");
        }
        if (arrayComponentType.isPrimitive()) {
            int len = submittedValue.length;
            Object convertedValues = Array.newInstance(arrayComponentType, len);
            for (int i = 0; i < len; ++i) {
                Array.set(convertedValues, i, converter.getAsObject(facesContext, component, submittedValue[i]));
            }
            return convertedValues;
        }
        int len = submittedValue.length;
        ArrayList<Object> convertedValues = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            convertedValues.add(i, converter.getAsObject(facesContext, component, submittedValue[i]));
        }
        return convertedValues.toArray((Object[])Array.newInstance(arrayComponentType, len));
    }

    private static void log(FacesContext context, String msg, Exception e) {
        context.getExternalContext().log(msg, e);
    }
}

