/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.el;

import java.util.HashMap;
import java.util.Map;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.apache.myfaces.view.facelets.PageContext;
import org.apache.myfaces.view.facelets.TemplateContext;
import org.apache.myfaces.view.facelets.el.CacheableValueExpression;
import org.apache.myfaces.view.facelets.el.CacheableValueExpressionWrapper;
import org.apache.myfaces.view.facelets.el.VariableMapperBase;

public final class DefaultVariableMapper
extends VariableMapperBase {
    private Map<String, ValueExpression> _vars;
    private PageContext _pageContext;
    private TemplateContext _templateContext;
    private VariableMapper _delegate;
    public boolean _trackResolveVariables;
    public boolean _variableResolved;

    public DefaultVariableMapper() {
        this._trackResolveVariables = false;
        this._variableResolved = false;
    }

    public DefaultVariableMapper(VariableMapper delegate) {
        this._delegate = delegate;
    }

    public ValueExpression resolveVariable(String name) {
        ValueExpression returnValue = null;
        if (this._vars != null) {
            returnValue = this._vars.get(name);
        }
        if (returnValue == null) {
            if (this._pageContext != null && this._pageContext.getAttributeCount() > 0 && this._pageContext.getAttributes().containsKey(name)) {
                returnValue = this._pageContext.getAttributes().get(name);
                if (this._trackResolveVariables) {
                    if (returnValue instanceof CacheableValueExpression) {
                        if (returnValue instanceof CacheableValueExpressionWrapper) {
                            returnValue = ((CacheableValueExpressionWrapper)returnValue).getWrapped();
                        }
                    } else {
                        this._variableResolved = true;
                    }
                }
                return returnValue;
            }
            if (this._templateContext != null) {
                if (!this._templateContext.isParameterEmpty() && this._templateContext.containsParameter(name)) {
                    returnValue = this._templateContext.getParameter(name);
                    if (this._trackResolveVariables && !(returnValue instanceof CacheableValueExpression)) {
                        this._variableResolved = true;
                    }
                    return returnValue;
                }
                if (!this._templateContext.isKnownParametersEmpty() && this._templateContext.containsKnownParameter(name) && this._trackResolveVariables) {
                    this._variableResolved = true;
                }
            }
            if (this._delegate != null) {
                returnValue = this._delegate.resolveVariable(name);
            }
        } else if (this._trackResolveVariables) {
            this._variableResolved = true;
        }
        return returnValue;
    }

    public ValueExpression setVariable(String name, ValueExpression expression) {
        if (this._vars == null) {
            this._vars = new HashMap<String, ValueExpression>();
        }
        return this._vars.put(name, expression);
    }

    public void setPageContext(PageContext pageContext) {
        this._pageContext = pageContext;
    }

    public void setTemplateContext(TemplateContext templateContext) {
        this._templateContext = templateContext;
    }

    @Override
    public boolean isAnyFaceletsVariableResolved() {
        if (this._trackResolveVariables) {
            return this._variableResolved;
        }
        return true;
    }

    @Override
    public void beforeConstructELExpression() {
        this._trackResolveVariables = true;
        this._variableResolved = false;
    }

    @Override
    public void afterConstructELExpression() {
        this._trackResolveVariables = false;
        this._variableResolved = false;
    }
}

