/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.myfaces.util.lang.AbstractThreadSafeAttributeMap;

public final class SessionMap
extends AbstractThreadSafeAttributeMap<Object> {
    private final HttpServletRequest httpRequest;

    SessionMap(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    @Override
    protected Object getAttribute(String key) {
        HttpSession httpSession = this.httpRequest.getSession(false);
        return httpSession == null ? null : httpSession.getAttribute(key);
    }

    @Override
    protected void setAttribute(String key, Object value) {
        this.httpRequest.getSession(true).setAttribute(key, value);
    }

    @Override
    protected void removeAttribute(String key) {
        HttpSession httpSession = this.httpRequest.getSession(false);
        if (httpSession != null) {
            httpSession.removeAttribute(key);
        }
    }

    @Override
    protected Enumeration<String> getAttributeNames() {
        HttpSession httpSession = this.httpRequest.getSession(false);
        return httpSession == null ? Collections.emptyEnumeration() : httpSession.getAttributeNames();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        throw new UnsupportedOperationException();
    }
}

