/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import org.apache.myfaces.application.FacesServletMapping;
import org.apache.myfaces.application.FacesServletMappingUtils;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.resource.ContractResourceLoader;
import org.apache.myfaces.resource.ResourceHandlerSupport;
import org.apache.myfaces.resource.ResourceLoader;

public class BaseResourceHandlerSupport
extends ResourceHandlerSupport {
    private static final ResourceLoader[] EMPTY_RESOURCE_LOADERS = new ResourceLoader[0];
    private static final ContractResourceLoader[] EMPTY_CONTRACT_RESOURCE_LOADERS = new ContractResourceLoader[0];
    private Long _startupTime = System.currentTimeMillis();
    private Long _maxTimeExpires;

    @Override
    public ResourceLoader[] getResourceLoaders() {
        return EMPTY_RESOURCE_LOADERS;
    }

    @Override
    public ContractResourceLoader[] getContractResourceLoaders() {
        return EMPTY_CONTRACT_RESOURCE_LOADERS;
    }

    @Override
    public ResourceLoader[] getViewResourceLoaders() {
        return EMPTY_RESOURCE_LOADERS;
    }

    @Override
    public String calculateResourceBasePath(FacesContext facesContext) {
        FacesServletMapping mapping = FacesServletMappingUtils.getCurrentRequestFacesServletMapping(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (mapping != null) {
            String resourceBasePath = null;
            if (!mapping.isExactMapping()) {
                if (mapping.isExtensionMapping()) {
                    resourceBasePath = externalContext.getRequestServletPath();
                    int stripPoint = resourceBasePath.lastIndexOf(46);
                    if (stripPoint > 0) {
                        resourceBasePath = resourceBasePath.substring(0, stripPoint);
                    }
                } else {
                    resourceBasePath = externalContext.getRequestPathInfo();
                }
            }
            return resourceBasePath;
        }
        return externalContext.getRequestPathInfo();
    }

    @Override
    public long getStartupTime() {
        return this._startupTime;
    }

    @Override
    public long getMaxTimeExpires() {
        if (this._maxTimeExpires == null) {
            this._maxTimeExpires = MyfacesConfig.getCurrentInstance().getResourceMaxTimeExpires();
        }
        return this._maxTimeExpires;
    }
}

