/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDecisionState;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDecisionVoterContext;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.ConversationExpirationEvaluator;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.RestParameters;

@Typed
class RestConversationExpirationEvaluator
implements ConversationExpirationEvaluator {
    private static final long serialVersionUID = 4586717766107967148L;
    private AccessDecisionVoterContext accessDecisionVoterContext;
    private RestParameters restParameters;
    private String oldRestId;
    private boolean resetPending = false;

    RestConversationExpirationEvaluator(BeanManager beanManager, AccessDecisionVoterContext accessDecisionVoterContext) {
        this.accessDecisionVoterContext = accessDecisionVoterContext;
        this.restParameters = (RestParameters)CodiUtils.getContextualReferenceByClass((BeanManager)beanManager, RestParameters.class, (Annotation[])new Annotation[0]);
    }

    public boolean isExpired() {
        if (this.resetPending) {
            return true;
        }
        if (this.accessDecisionVoterContext != null && AccessDecisionState.VOTE_IN_PROGRESS.equals((Object)this.accessDecisionVoterContext.getState())) {
            return false;
        }
        return this.isNewRestId();
    }

    protected boolean isNewRestId() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return false;
        }
        if (this.restParameters.isPostback()) {
            return false;
        }
        String currentRestId = this.restParameters.getRestId();
        return currentRestId != null && !currentRestId.equals(this.oldRestId);
    }

    public void touch() {
        if (this.oldRestId == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null) {
                return;
            }
            this.oldRestId = this.restParameters.getRestId();
        }
    }

    public void expire() {
        this.resetPending = true;
    }
}

