/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation.servlet;

import java.util.Enumeration;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.conversation.ConversationManager;
import org.apache.myfaces.orchestra.conversation.ConversationWiperThread;
import org.apache.myfaces.orchestra.conversation.basic.LogConversationMessager;
import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;
import org.apache.myfaces.orchestra.frameworkAdapter.local.LocalFrameworkAdapter;

public class ConversationManagerSessionListener
implements ServletContextListener,
HttpSessionListener,
HttpSessionAttributeListener,
HttpSessionActivationListener {
    private final Log log = LogFactory.getLog(ConversationManagerSessionListener.class);
    private static final long DEFAULT_CHECK_TIME = 300000L;
    private static final String CHECK_TIME = "org.apache.myfaces.orchestra.WIPER_THREAD_CHECK_TIME";
    private ConversationWiperThread conversationWiperThread;

    public void contextInitialized(ServletContextEvent event) {
        this.log.debug((Object)"contextInitialized");
        long checkTime = 300000L;
        String checkTimeString = event.getServletContext().getInitParameter(CHECK_TIME);
        if (checkTimeString != null) {
            checkTime = Long.parseLong(checkTimeString);
        }
        if (this.conversationWiperThread == null) {
            this.conversationWiperThread = new ConversationWiperThread(checkTime);
            this.conversationWiperThread.setName("Orchestra:ConversationWiperThread");
            this.conversationWiperThread.start();
        } else {
            this.log.error((Object)"context initialised more than once");
        }
        this.log.debug((Object)"initialised");
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.log.debug((Object)"Context destroyed");
        if (this.conversationWiperThread != null) {
            this.conversationWiperThread.interrupt();
            this.conversationWiperThread = null;
        } else {
            this.log.error((Object)"Context destroyed more than once");
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            String attrName = (String)e.nextElement();
            Object o = session.getAttribute(attrName);
            if (!(o instanceof ConversationManager)) continue;
            this.log.debug((Object)"Session containing a ConversationManager has been destroyed (eg timed out)");
            session.removeAttribute(attrName);
        }
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        if (event.getValue() instanceof ConversationManager) {
            ConversationManager cm = (ConversationManager)event.getValue();
            this.conversationWiperThread.addConversationManager(cm);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        if (event.getValue() instanceof ConversationManager) {
            this.log.debug((Object)"A ConversationManager instance has been removed from a session");
            ConversationManager cm = (ConversationManager)event.getValue();
            this.removeAndInvalidateConversationManager(cm);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        String attrName;
        HttpSession session;
        Object newObj;
        if (event.getValue() instanceof ConversationManager) {
            ConversationManager oldConversationManager = (ConversationManager)event.getValue();
            this.removeAndInvalidateConversationManager(oldConversationManager);
        }
        if ((newObj = (session = event.getSession()).getAttribute(attrName = event.getName())) instanceof ConversationManager) {
            ConversationManager newConversationManager = (ConversationManager)newObj;
            this.conversationWiperThread.addConversationManager(newConversationManager);
        }
    }

    public void sessionDidActivate(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            String attrName = (String)e.nextElement();
            Object val = session.getAttribute(attrName);
            if (!(val instanceof ConversationManager)) continue;
            ConversationManager cm = (ConversationManager)val;
            this.conversationWiperThread.addConversationManager(cm);
        }
    }

    public void sessionWillPassivate(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            String attrName = (String)e.nextElement();
            Object val = session.getAttribute(attrName);
            if (!(val instanceof ConversationManager)) continue;
            ConversationManager cm = (ConversationManager)val;
            this.conversationWiperThread.removeConversationManager(cm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAndInvalidateConversationManager(ConversationManager cm) {
        FrameworkAdapter currentFrameworkAdapter = FrameworkAdapter.getCurrentInstance();
        try {
            LocalFrameworkAdapter fa = new LocalFrameworkAdapter();
            LogConversationMessager conversationMessager = new LogConversationMessager();
            fa.setConversationMessager(conversationMessager);
            FrameworkAdapter.setCurrentInstance(fa);
            this.conversationWiperThread.removeConversationManager(cm);
            cm.removeAndInvalidateAllConversationContexts();
        }
        finally {
            FrameworkAdapter.setCurrentInstance(currentFrameworkAdapter);
            if (currentFrameworkAdapter != null) {
                this.log.warn((Object)"removeAndInvalidateConversationManager: currentFrameworkAdapter is not null..");
            }
        }
    }
}

