// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.component;

import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIGridLayout;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.renderkit.MarginValues;
import org.apache.myfaces.tobago.renderkit.SpacingValues;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRenderer;
import javax.el.ELException;
import javax.faces.FacesException;
import java.util.ArrayList;
import java.util.List;
import javax.el.MethodExpression;
import javax.el.ValueExpression;

/** 
 Renders a GridLayout.
  <pre>
  columns/rows ::= LAYOUT
  LAYOUT       ::= TOKEN [";" TOKEN]+
  TOKEN        ::= AUTO | PIXEL | PROPORTIONAL
  AUTO         ::= "auto" | "fixed"
  PIXEL        ::= NUMBER "px"
  PROPORTIONAL ::= [NUMBER] "*"
  </pre>
  <p/>
  <table border="1">
  <tr>
  <th>Parent</th>
  <th>Child</th>
  <th>Okay?</th>
  <th>Remarks</th>
  </tr>
  <tr>
  <td>AUTO</td>
  <td>any combination of AUTO or PIXEL but no PROPORTIONAL</td>
  <td>okay</td>
  <td>-</td>
  </tr>
  <tr>
  <td>AUTO</td>
  <td>any combination with at least one PROPORTIONAL</td>
  <td>wrong</td>
  <td>LayoutManager cannot compute the auto value.</td>
  </tr>
  <tr>
  <td>PIXEL</td>
  <td>any combination of AUTO or PIXEL but no PROPORTIONAL</td>
  <td>potentially wrong</td>
  <td>The values depend on each other, the programmer has to keep consistency manually.</td>
  </tr>
  <tr>
  <td>PIXEL</td>
  <td>any combination with at least one PROPORTIONAL</td>
  <td>okay</td>
  <td>-</td>
  </tr>
  <tr>
  <td>PROPORTIONAL</td>
  <td>any combination of AUTO or PIXEL but no PROPORTIONAL</td>
  <td>potentially wrong</td>
  <td>No automatic matching:<ul><li>too little space: scroll bar</li>
  <li>too much space: elements will be spread.</li></ul></td>
  </tr>
  <tr>
  <td>PROPORTIONAL</td>
  <td>any combination with at least one PROPORTIONAL</td>
  <td>okay</td>
  <td>-</td>
  </tr>
  </table>
  * UIComponent class, generated from template {@code component2.0.stg} with class
  * {@link org.apache.myfaces.tobago.internal.taglib.component.GridLayoutTagDeclaration}.
 */
public class UIGridLayout
    extends AbstractUIGridLayout implements SupportsMarkup {

  public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.GridLayout";

  public static final String COMPONENT_FAMILY = "org.apache.myfaces.tobago.GridLayout";

  private org.apache.myfaces.tobago.context.Markup currentMarkup;

  enum PropertyKeys {
    border,
    columnSpacing,
    margin,
    markup,
    columns,
    rows,
    marginLeft,
    marginRight,
    rowOverflow,
    cellspacing,
    marginBottom,
    rowSpacing,
    rigid,
    columnOverflow,
    marginTop,
  }

  public String getFamily() {
    return COMPONENT_FAMILY;
  }


  /**
  Border size of this component.

  */
  public java.lang.String getBorder() {
    return (java.lang.String) getStateHelper().eval(PropertyKeys.border);
  }

  public void setBorder(java.lang.String border) {
    getStateHelper().put(PropertyKeys.border, border);
  }

  /**
  Spacing between the columns in the actual layout.

  */
  public org.apache.myfaces.tobago.layout.Measure getColumnSpacing() {
    Object object = getStateHelper().eval(PropertyKeys.columnSpacing);
    if (object != null) {
       return Measure.valueOf(object);
    }
    return getCellspacing() != null
   ? getCellspacing()
   : getRendererType() != null ? ((SpacingValues)getRenderer(getFacesContext())).getColumnSpacing(getFacesContext(), this) : Measure.ZERO;
  }

  public void setColumnSpacing(org.apache.myfaces.tobago.layout.Measure columnSpacing) {
    getStateHelper().put(PropertyKeys.columnSpacing, columnSpacing);
  }

  /**
  Margin between container component and the children.

  @deprecated*/
  @Deprecated
  public org.apache.myfaces.tobago.layout.Measure getMargin() {
    Object object = getStateHelper().eval(PropertyKeys.margin);
    if (object != null) {
       return Measure.valueOf(object);
    }
    return null;
  }

  @Deprecated
  public void setMargin(org.apache.myfaces.tobago.layout.Measure margin) {
      Deprecation.LOG.error("The attribute 'margin' of 'UIGridLayout' is deprecated. "
          + "Please refer the documentation for further information.");
    getStateHelper().put(PropertyKeys.margin, margin);
  }

  public org.apache.myfaces.tobago.context.Markup getMarkup() {
    Object object = getStateHelper().eval(PropertyKeys.markup);
    if (object != null) {
      return Markup.valueOf(object);
    }
    return null;
  }

  public void setMarkup(org.apache.myfaces.tobago.context.Markup markup) {
    getStateHelper().put(PropertyKeys.markup, markup);
  }

  /**
  This value defines the layout constraints for column layout. It is a semicolon separated list of layout tokens
   '[&lt;n>]*', '&lt;n>px' or 'auto'. Where &lt;n> is a non negative integer and the square brackets means optional.
   Example: '2*;*;100px;auto'.
  <br />Default: <code>1*</code>
  */
  public java.lang.String getColumns() {
    java.lang.String columns = (java.lang.String) getStateHelper().eval(PropertyKeys.columns);
    if (columns != null) {
      return columns;
    }
    return "1*";
  }

  public void setColumns(java.lang.String columns) {
    getStateHelper().put(PropertyKeys.columns, columns);
  }

  /**
  This value defines the layout constraints for column layout. It is a semicolon separated list of layout tokens
   '[&lt;n>]*', '&lt;n>px' or 'auto'. Where &lt;n> is a non negative integer and the square brackets means optional.
   Example: '2*;*;100px;auto'.
  <br />Default: <code>1*</code>
  */
  public java.lang.String getRows() {
    java.lang.String rows = (java.lang.String) getStateHelper().eval(PropertyKeys.rows);
    if (rows != null) {
      return rows;
    }
    return "1*";
  }

  public void setRows(java.lang.String rows) {
    getStateHelper().put(PropertyKeys.rows, rows);
  }

  public org.apache.myfaces.tobago.context.Markup getCurrentMarkup() {
    if (currentMarkup != null) {
      return currentMarkup;
    }
    return null;
  }

  public void setCurrentMarkup(org.apache.myfaces.tobago.context.Markup currentMarkup) {
    this.currentMarkup = currentMarkup;
  }

  /**
  Left margin between container component and the children.

  */
  public org.apache.myfaces.tobago.layout.Measure getMarginLeft() {
    Object object = getStateHelper().eval(PropertyKeys.marginLeft);
    if (object != null) {
       return Measure.valueOf(object);
    }
    return getMargin() != null
   ? getMargin()
   : getRendererType() != null ? ((MarginValues)getRenderer(getFacesContext())).getMarginLeft(getFacesContext(), this) : Measure.ZERO;
  }

  public void setMarginLeft(org.apache.myfaces.tobago.layout.Measure marginLeft) {
    getStateHelper().put(PropertyKeys.marginLeft, marginLeft);
  }

  /**
  Right margin between container component and the children.

  */
  public org.apache.myfaces.tobago.layout.Measure getMarginRight() {
    Object object = getStateHelper().eval(PropertyKeys.marginRight);
    if (object != null) {
       return Measure.valueOf(object);
    }
    return getMargin() != null
   ? getMargin()
   : getRendererType() != null ? ((MarginValues)getRenderer(getFacesContext())).getMarginRight(getFacesContext(), this) : Measure.ZERO;
  }

  public void setMarginRight(org.apache.myfaces.tobago.layout.Measure marginRight) {
    getStateHelper().put(PropertyKeys.marginRight, marginRight);
  }

  /**
  This attribute is a hint for the layout manager. Should not be used in most cases.

  */
  public boolean isRowOverflow() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.rowOverflow);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  public void setRowOverflow(boolean rowOverflow) {
    getStateHelper().put(PropertyKeys.rowOverflow, rowOverflow);
  }

  /**
  Spacing between component and layout cell's. Can be overwritten by columnSpacing and rowSpacing.

  @deprecated*/
  @Deprecated
  public org.apache.myfaces.tobago.layout.Measure getCellspacing() {
    Object object = getStateHelper().eval(PropertyKeys.cellspacing);
    if (object != null) {
       return Measure.valueOf(object);
    }
    return null;
  }

  @Deprecated
  public void setCellspacing(org.apache.myfaces.tobago.layout.Measure cellspacing) {
      Deprecation.LOG.error("The attribute 'cellspacing' of 'UIGridLayout' is deprecated. "
          + "Please refer the documentation for further information.");
    getStateHelper().put(PropertyKeys.cellspacing, cellspacing);
  }

  /**
  Bottom margin between container component and the children.

  */
  public org.apache.myfaces.tobago.layout.Measure getMarginBottom() {
    Object object = getStateHelper().eval(PropertyKeys.marginBottom);
    if (object != null) {
       return Measure.valueOf(object);
    }
    return getMargin() != null
   ? getMargin()
   : getRendererType() != null ? ((MarginValues)getRenderer(getFacesContext())).getMarginBottom(getFacesContext(), this) : Measure.ZERO;
  }

  public void setMarginBottom(org.apache.myfaces.tobago.layout.Measure marginBottom) {
    getStateHelper().put(PropertyKeys.marginBottom, marginBottom);
  }

  /**
  Spacing between the rows in the actual layout.

  */
  public org.apache.myfaces.tobago.layout.Measure getRowSpacing() {
    Object object = getStateHelper().eval(PropertyKeys.rowSpacing);
    if (object != null) {
       return Measure.valueOf(object);
    }
    return getCellspacing() != null
   ? getCellspacing()
   : getRendererType() != null ? ((SpacingValues)getRenderer(getFacesContext())).getRowSpacing(getFacesContext(), this) : Measure.ZERO;
  }

  public void setRowSpacing(org.apache.myfaces.tobago.layout.Measure rowSpacing) {
    getStateHelper().put(PropertyKeys.rowSpacing, rowSpacing);
  }

  /**
  This attribute advises the layout manager, to not use space that comes from non rendered components.

  */
  public boolean isRigid() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.rigid);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  public void setRigid(boolean rigid) {
    getStateHelper().put(PropertyKeys.rigid, rigid);
  }

  /**
  This attribute is a hint for the layout manager. Should not be used in most cases.

  */
  public boolean isColumnOverflow() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.columnOverflow);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  public void setColumnOverflow(boolean columnOverflow) {
    getStateHelper().put(PropertyKeys.columnOverflow, columnOverflow);
  }

  /**
  Top margin between container component and the children.

  */
  public org.apache.myfaces.tobago.layout.Measure getMarginTop() {
    Object object = getStateHelper().eval(PropertyKeys.marginTop);
    if (object != null) {
       return Measure.valueOf(object);
    }
    return getMargin() != null
   ? getMargin()
   : getRendererType() != null ? ((MarginValues)getRenderer(getFacesContext())).getMarginTop(getFacesContext(), this) : Measure.ZERO;
  }

  public void setMarginTop(org.apache.myfaces.tobago.layout.Measure marginTop) {
    getStateHelper().put(PropertyKeys.marginTop, marginTop);
  }

  public Object saveState(FacesContext context) {
    currentMarkup = null;
    return super.saveState(context);
  }

}