/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeMenu;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeMenuTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(TreeMenuTag.class);
    private ValueExpression state;
    private ValueExpression value;
    private ValueExpression markup;
    private String var;
    private ValueExpression showRoot;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.TreeMenu";
    }

    public String getRendererType() {
        return "TreeMenu";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UITreeMenu component = (UITreeMenu)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.state != null && !this.state.isLiteralText()) {
            component.setValueExpression("state", this.state);
        }
        if (this.value != null) {
            component.setValueExpression("value", this.value);
        }
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.var != null) {
            component.setVar(this.var);
        }
        if (this.showRoot != null) {
            if (!this.showRoot.isLiteralText()) {
                component.setValueExpression("showRoot", this.showRoot);
            } else {
                component.setShowRoot(Boolean.parseBoolean(this.showRoot.getExpressionString()));
            }
        }
    }

    public ValueExpression getState() {
        return this.state;
    }

    public void setState(ValueExpression state) {
        this.state = state;
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public ValueExpression getShowRoot() {
        return this.showRoot;
    }

    public void setShowRoot(ValueExpression showRoot) {
        this.showRoot = showRoot;
    }

    public void release() {
        super.release();
        this.state = null;
        this.value = null;
        this.markup = null;
        this.var = null;
        this.showRoot = null;
    }
}

